/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.storage.PlayerData;
import org.strassburger.cookieclickerz.util.MessageUtils;
import org.strassburger.cookieclickerz.util.NumFormatter;
import org.strassburger.cookieclickerz.util.PrestigeData;
import org.strassburger.cookieclickerz.util.gui.GuiAssets;
import org.strassburger.cookieclickerz.util.items.CustomItem;

public class MainGUI {
    private static final List<UUID> openInventories = new ArrayList<UUID>();

    private MainGUI() {
    }

    public static boolean isOpen(Player player) {
        return openInventories.contains(player.getUniqueId());
    }

    public static void open(Player player) {
        CookieClickerZ plugin = CookieClickerZ.getInstance();
        PlayerData playerData = plugin.getStorage().load(player.getUniqueId());
        Inventory inventory = Bukkit.createInventory(null, (int)45, (Component)MessageUtils.getAndFormatMsg(false, "inventories.main.title", "&8CookieClickerZ", new MessageUtils.Replaceable[0]));
        GuiAssets.addBorder(inventory);
        inventory.setItem(11, new CustomItem(Material.GOLD_INGOT).setName(MessageUtils.getAndFormatMsg(false, "inventories.main.shopTitle", "&e&lShop", new MessageUtils.Replaceable[0])).setLore(MessageUtils.getAndFormatMsgList("inventories.main.shopDescription", new MessageUtils.Replaceable[0])).getItemStack());
        inventory.setItem(15, new CustomItem(Material.EXPERIENCE_BOTTLE).setName(MessageUtils.getAndFormatMsg(false, "inventories.main.achievementsTitle", "<#9932cc>&lBoosters", new MessageUtils.Replaceable[0])).setLore(MessageUtils.getAndFormatMsgList("inventories.main.achievementsDescription", new MessageUtils.Replaceable[0])).getItemStack());
        inventory.setItem(22, new CustomItem(Material.COOKIE).setName(MessageUtils.getAndFormatMsg(false, "inventories.main.clickerTitle", "%ac%&lYour Cookies", new MessageUtils.Replaceable[0])).setLore(MessageUtils.getAndFormatMsgList("inventories.main.clickerDescription", new MessageUtils.Replaceable<String>("%cookies%", NumFormatter.formatBigInt(playerData.getTotalCookies())), new MessageUtils.Replaceable<String>("%cpc%", NumFormatter.formatBigInt(playerData.getCookiesPerClick())), new MessageUtils.Replaceable<String>("%offlinecookies%", NumFormatter.formatBigInt(playerData.getOfflineCookies())), new MessageUtils.Replaceable<Integer>("%multiplier%", new PrestigeData(plugin, playerData.getPrestige()).getMultiplier()), new MessageUtils.Replaceable<String>("%score%", playerData.getFormattedScore()))).getItemStack());
        inventory.setItem(29, new CustomItem(Material.FEATHER).setName(MessageUtils.getAndFormatMsg(false, "inventories.main.prestigeTitle", "&6&lPrestige", new MessageUtils.Replaceable[0])).setLore(MessageUtils.getAndFormatMsgList("inventories.main.prestigeDescription", new MessageUtils.Replaceable[0])).getItemStack());
        inventory.setItem(33, new CustomItem(CustomItem.getHead((OfflinePlayer)player)).setName(MessageUtils.getAndFormatMsg(false, "inventories.main.topTitle", "<#FF5733>&lTop Players", new MessageUtils.Replaceable[0])).setLore(MessageUtils.getAndFormatMsgList("inventories.main.topDescription", new MessageUtils.Replaceable[0])).getItemStack());
        player.openInventory(inventory);
        openInventories.add(player.getUniqueId());
    }

    public static void close(Player player) {
        if (MainGUI.isOpen(player)) {
            openInventories.remove(player.getUniqueId());
        }
    }
}

