/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util.gui;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.storage.PlayerData;
import org.strassburger.cookieclickerz.storage.Storage;
import org.strassburger.cookieclickerz.util.MessageUtils;
import org.strassburger.cookieclickerz.util.gui.GuiAssets;

public class UpgradeGUI {
    private static final List<UUID> openInventories = new ArrayList<UUID>();
    private static final FileConfiguration config = CookieClickerZ.getInstance().getConfigManager().getUpgradesConfig();
    private static final int ITEMS_PER_PAGE = 28;

    private UpgradeGUI() {
    }

    public static boolean isOpen(Player player) {
        return openInventories.contains(player.getUniqueId());
    }

    public static void open(Player player) {
        UpgradeGUI.open(player, 1);
    }

    public static void open(Player player, int page) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtils.getAndFormatMsg(false, "inventories.main.title", "&8CookieClickerZ", new MessageUtils.Replaceable[0]));
        GuiAssets.addBorder(inventory);
        GuiAssets.addBackButton(inventory);
        Storage storage = CookieClickerZ.getInstance().getStorage();
        PlayerData playerData = storage.load(player.getUniqueId());
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        for (String key : config.getKeys(false)) {
            Upgrade upgrade = new Upgrade(key);
            int upgradelevel = playerData.getUpgradeLevel("upgrade_" + upgrade.getId());
            BigInteger upgradePrice = upgrade.getBaseprice().multiply(BigInteger.valueOf((long)Math.pow(upgrade.getPriceMultiplier(), upgradelevel)));
            upgrade.setUpgradePrice(upgradePrice);
            upgrade.setAffordable(playerData.getTotalCookies().compareTo(upgradePrice) >= 0);
            upgrade.setLevel(upgradelevel);
            upgrades.add(upgrade);
        }
        List<Upgrade> itemsForPage = UpgradeGUI.getItemsForPage(upgrades, page);
        for (Upgrade upgrade : itemsForPage) {
            inventory.addItem(new ItemStack[]{GuiAssets.createUpgradeItem(upgrade)});
        }
        GuiAssets.addPagination(inventory, page, page > 1, page < (int)Math.ceil((double)upgrades.size() / 28.0));
        player.openInventory(inventory);
        openInventories.add(player.getUniqueId());
    }

    public static void close(Player player) {
        if (UpgradeGUI.isOpen(player)) {
            openInventories.remove(player.getUniqueId());
        }
    }

    private static List<Upgrade> getItemsForPage(List<Upgrade> upgrades, int page) {
        int totalItems = upgrades.size();
        int totalPages = (int)Math.ceil((double)totalItems / 28.0);
        if (page < 1 || page > totalPages) {
            throw new IllegalArgumentException("Invalid page number: " + page);
        }
        int startIndex = (page - 1) * 28;
        int endIndex = Math.min(startIndex + 28, totalItems);
        return new ArrayList<Upgrade>(upgrades.subList(startIndex, endIndex));
    }

    public static class Upgrade {
        private final String id;
        private String name;
        private BigInteger baseprice;
        private double priceMultiplier;
        private String item;
        private BigInteger cpc;
        private BigInteger offlineCookies;
        private BigInteger upgradePrice;
        private boolean affordable;
        private int level;

        public Upgrade(String id, String name, BigInteger baseprice, double priceMultiplier, String item, BigInteger cpc, BigInteger offlineCookies) {
            this.id = id;
            this.name = name;
            this.baseprice = baseprice;
            this.priceMultiplier = priceMultiplier;
            this.item = item;
            this.cpc = cpc;
            this.offlineCookies = offlineCookies;
        }

        public Upgrade(String id) {
            this.id = id;
            this.name = config.getString(id + ".name");
            this.baseprice = new BigInteger(config.getString(id + ".baseprice", "0"));
            this.priceMultiplier = config.getDouble(id + ".priceMultiplier");
            this.item = config.getString(id + ".item");
            this.cpc = new BigInteger(config.getString(id + ".cpc", "0"));
            this.offlineCookies = new BigInteger(config.getString(id + ".offlineCookies", "0"));
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isAffordable() {
            return this.affordable;
        }

        public void setAffordable(boolean affordable) {
            this.affordable = affordable;
        }

        public BigInteger getUpgradePrice() {
            return this.upgradePrice;
        }

        public void setUpgradePrice(BigInteger upgradePrice) {
            this.upgradePrice = upgradePrice;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public BigInteger getBaseprice() {
            return this.baseprice;
        }

        public void setBaseprice(BigInteger baseprice) {
            this.baseprice = baseprice;
        }

        public double getPriceMultiplier() {
            return this.priceMultiplier;
        }

        public void setPriceMultiplier(double priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
        }

        public String getItem() {
            return this.item;
        }

        public void setItem(String item) {
            this.item = item;
        }

        public BigInteger getCpc() {
            return this.cpc;
        }

        public void setCpc(BigInteger cpc) {
            this.cpc = cpc;
        }

        public BigInteger getOfflineCookies() {
            return this.offlineCookies;
        }

        public void setOfflineCookies(BigInteger offlineCookies) {
            this.offlineCookies = offlineCookies;
        }
    }
}

