/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util.items;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.strassburger.cookieclickerz.CookieClickerZ;
import org.strassburger.cookieclickerz.util.MessageUtils;
import org.strassburger.cookieclickerz.util.items.SkullUtils;

public class CustomItem {
    private final ItemStack itemStack;

    public CustomItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public CustomItem(Material material) {
        this.itemStack = new ItemStack(material);
    }

    public CustomItem() {
        this.itemStack = new ItemStack(Material.AIR);
    }

    public static CustomItem fromSkullBase64(String base64) throws MalformedURLException {
        return new CustomItem(SkullUtils.getSkullFromBase64(base64));
    }

    public static CustomItem fromSkullUrl(String url) throws MalformedURLException {
        return new CustomItem(SkullUtils.getSkullFromUrl(url));
    }

    public CustomItem setMaterial(Material material) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        int amount = this.itemStack.getAmount();
        ItemStack newItemStack = new ItemStack(material, amount);
        newItemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    public CustomItem setName(String name) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.displayName(MessageUtils.formatMsg(name, new MessageUtils.Replaceable[0]));
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem setName(Component name) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.displayName(name);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem setCustomModelID(int customModelID) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(customModelID));
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem setUnbreakable(boolean unbreakable) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.setUnbreakable(unbreakable);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem setEnchanted(boolean enchanted) {
        if (!enchanted) {
            return this;
        }
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addEnchant(Enchantment.UNBREAKING, 1, true);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public <P, C> CustomItem setCustomDataContainer(NamespacedKey key, PersistentDataType<P, C> persistentDataType, C value) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(key, persistentDataType, value);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public <P, C> CustomItem setCustomDataContainer(String key, PersistentDataType<P, C> persistentDataType, C value) {
        return this.setCustomDataContainer(new NamespacedKey((Plugin)CookieClickerZ.getInstance(), key), persistentDataType, value);
    }

    public <P, C> C getCustomDataContainer(NamespacedKey key, PersistentDataType<P, C> persistentDataType) {
        return (C)this.itemStack.getItemMeta().getPersistentDataContainer().get(key, persistentDataType);
    }

    public <P, C> C getCustomDataContainer(String key, PersistentDataType<P, C> persistentDataType) {
        return this.getCustomDataContainer(new NamespacedKey((Plugin)CookieClickerZ.getInstance(), key), persistentDataType);
    }

    public CustomItem addFlag(ItemFlag itemFlag) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem addEnchantment(Enchantment enchantment, int level) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.addEnchant(enchantment, level, true);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.itemStack.getItemMeta().getPersistentDataContainer();
    }

    public CustomItem setLore(List<Component> lore) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        ArrayList<Component> newLore = new ArrayList<Component>(lore.size());
        newLore.addAll(lore);
        itemMeta.lore(newLore);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public CustomItem addLore(String lore) {
        return this.addLore(MessageUtils.formatMsg(lore, new MessageUtils.Replaceable[0]));
    }

    public CustomItem addLore(Component lore) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        ArrayList<Component> newLore = new ArrayList<Component>(Objects.requireNonNull(itemMeta.lore()));
        newLore.add(lore);
        itemMeta.lore(newLore);
        this.itemStack.setItemMeta(itemMeta);
        return this;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public static ItemStack getHead(OfflinePlayer player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        if (skullMeta != null && player != null && player.getName() != null) {
            skullMeta.setOwningPlayer(player);
            skullMeta.displayName(MessageUtils.formatMsg("&e" + player.getName(), new MessageUtils.Replaceable[0]));
            head.setItemMeta((ItemMeta)skullMeta);
        }
        return head;
    }

    public static ItemStack getHead(UUID uuid) {
        OfflinePlayer player = CookieClickerZ.getInstance().getServer().getOfflinePlayer(uuid);
        return CustomItem.getHead(player);
    }
}

