/*
 * Decompiled with CFR 0.152.
 */
package org.strassburger.cookieclickerz.util.items;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;

public final class SkullUtils {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    private SkullUtils() {
    }

    private static PlayerProfile getProfile(String url) throws MalformedURLException {
        PlayerProfile profile = Bukkit.createProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        URL urlObject = new URL(url);
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    public static URL getUrlFromBase64(String base64) throws MalformedURLException {
        String decoded = new String(Base64.getDecoder().decode(base64));
        return new URL(decoded.substring("{\"textures\":{\"SKIN\":{\"url\":\"".length(), decoded.length() - "\"}}}".length()));
    }

    public static ItemStack getSkullFromUrl(String url) throws MalformedURLException {
        PlayerProfile profile = SkullUtils.getProfile(url);
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (skullMeta != null) {
            skullMeta.setPlayerProfile(profile);
            skull.setItemMeta((ItemMeta)skullMeta);
        }
        return skull;
    }

    public static ItemStack getSkullFromBase64(String base64) throws MalformedURLException {
        URL url = SkullUtils.getUrlFromBase64(base64);
        return SkullUtils.getSkullFromUrl(url.toString());
    }
}

