/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class NumFormatter {
    private static final String[] suffixes = new String[]{"", "K", "M", "B", "T", "Q", "QQ", "S", "SS", "O", "N", "D"};
    private static final BigInteger[] multipliers = new BigInteger[suffixes.length];

    private NumFormatter() {
    }

    private static BigDecimal convertStringToBigDecimal(String str) {
        for (int i = suffixes.length - 1; i >= 1; --i) {
            if (!str.endsWith(suffixes[i])) continue;
            String numberPart = str.substring(0, str.length() - suffixes[i].length());
            try {
                return new BigDecimal(numberPart).multiply(new BigDecimal(multipliers[i]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BigInteger stringToBigInteger(String str) {
        BigDecimal bigDecimal = NumFormatter.convertStringToBigDecimal(str);
        return bigDecimal != null ? bigDecimal.toBigInteger() : null;
    }

    public static BigDecimal stringToBigDecimal(String str) {
        return NumFormatter.convertStringToBigDecimal(str);
    }

    private static String formatNumber(BigDecimal number) {
        int index;
        number = number.setScale(2, RoundingMode.DOWN);
        for (index = 0; number.compareTo(BigDecimal.valueOf(1000L)) >= 0 && index < suffixes.length - 1; ++index) {
            number = number.divide(BigDecimal.valueOf(1000L), 2, RoundingMode.DOWN);
        }
        return number.stripTrailingZeros().toPlainString() + suffixes[index];
    }

    public static String formatBigInt(BigInteger bigInt) {
        return NumFormatter.formatNumber(new BigDecimal(bigInt));
    }

    public static String formatBigDecimal(BigDecimal bigDecimal) {
        return NumFormatter.formatNumber(bigDecimal);
    }

    static {
        NumFormatter.multipliers[0] = BigInteger.ONE;
        for (int i = 1; i < multipliers.length; ++i) {
            NumFormatter.multipliers[i] = multipliers[i - 1].multiply(BigInteger.valueOf(1000L));
        }
    }
}

