/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import java.math.BigInteger;
import java.util.Random;

public class RandomGenerators {
    private RandomGenerators() {
    }

    public static String generateRandomWord(int wordLength) {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random();
        StringBuilder word = new StringBuilder(wordLength);
        for (int i = 0; i < wordLength; ++i) {
            int index = random.nextInt(alphabet.length());
            word.append(alphabet.charAt(index));
        }
        return word.toString();
    }

    public static int generateRandomNumber(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min + 1) + min;
    }

    public static long generateRandomLong(long min, long max) {
        Random random = new Random();
        return random.nextLong() % (max - min + 1L) + min;
    }

    public static BigInteger generateRandomBigInteger(BigInteger min, BigInteger max) {
        Random random = new Random();
        BigInteger range = max.subtract(min);
        int length = range.bitLength();
        BigInteger result = new BigInteger(length, random);
        if (result.compareTo(min) < 0) {
            result = result.add(min);
        }
        if (result.compareTo(range) >= 0) {
            result = result.mod(range).add(min);
        }
        return result;
    }
}

