package chaos.amyshield;

import chaos.amyshield.datagen.DynamicRegistryProvider;
import chaos.amyshield.datagen.LootTableProvider;
import chaos.amyshield.datagen.ModEnchantmentTagModifier;
import chaos.amyshield.datagen.ModTagProvider;
import chaos.amyshield.enchantments.ModEnchantments;
import chaos.amyshield.tag.ModTags;
import chaos.amyshield.world.ModConfiguredFeatures;
import chaos.amyshield.world.ModPlacedFeatures;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1887;
import net.minecraft.class_7877;
import net.minecraft.class_7924;
import net.minecraft.class_9274;

public class AmethystShieldDatagen implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();

        pack.addProvider(DynamicRegistryProvider::new);

        pack.addProvider(ModEnchantmentTagModifier::new);

        pack.addProvider(LootTableProvider.Block::new);

        pack.addProvider(ModTagProvider.ModBlockTagProvider::new);
        pack.addProvider(ModTagProvider.ModItemTagProvider::new);
        pack.addProvider(ModTagProvider.ModEntityProvider::new);
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, ModConfiguredFeatures::boostrap);
        registryBuilder.method_46777(class_7924.field_41245, ModPlacedFeatures::boostrap);

        registryBuilder.method_46777(class_7924.field_41265, (context) -> {

            final var items = context.method_46799(class_7924.field_41197);
            context.method_46838(ModEnchantments.SENSITIVITY, class_1887.method_60030(
                            class_1887.method_58442(
                                    items.method_46735(ModTags.AMETHYST_SHIELD_ENCHANTABLE),
                                    // this is the "weight" or probability of our enchantment showing up in the table
                                    10,
                                    // the maximum level of the enchantment
                                    3,
                                    // base cost for level 1 of the enchantment, and min levels required for something higher
                                    class_1887.method_58441(1, 10),
                                    // same fields as above but for max cost
                                    class_1887.method_58441(1, 15),
                                    // anvil cost
                                    5,
                                    // valid slots
                                    class_9274.field_49219
                            )
                    ).method_60060(ModEnchantments.SENSITIVITY.method_29177())
            );


            context.method_46838(ModEnchantments.RELEASE, class_1887.method_60030(
                class_1887.method_58442(
                    items.method_46735(ModTags.AMETHYST_SHIELD_ENCHANTABLE),
                    // this is the "weight" or probability of our enchantment showing up in the table
                    10,
                    // the maximum level of the enchantment
                    3,
                    // base cost for level 1 of the enchantment, and min levels required for something higher
                    class_1887.method_58441(1, 10),
                    // same fields as above but for max cost
                    class_1887.method_58441(1, 15),
                    // anvil cost
                    5,
                    // valid slots
                    class_9274.field_49219
                ))
                .method_60060(ModEnchantments.RELEASE.method_29177())
            );
        });
    }
}
