package chaos.amyshield.block.custom;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.block.blockEntities.ModBlockEntities;
import chaos.amyshield.block.blockEntities.custom.AmethystDispenserBlockEntity;
import net.minecraft.block.*;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2343;
import net.minecraft.class_2357;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class AmethystDispenserBlock extends class_2315 implements class_2343 {
    public AmethystDispenserBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_10918, field_10920);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 stack = class_1802.field_8357.method_8389().method_7854();
        if (includeData && world.method_8321(pos) instanceof AmethystDispenserBlockEntity amethystDispenserBlockEntity) {
            class_9323 map = class_9323.method_57827().method_57840(class_9334.field_49622, class_9288.method_57493(amethystDispenserBlockEntity.getInventory())).method_57838();

            stack.method_57365(map);
        }
        return stack;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AmethystDispenserBlockEntity(pos, state);
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!(world.method_8321(pos) instanceof AmethystDispenserBlockEntity amethystDispenserBlockEntity)) {
            return;
        }

        if (amethystDispenserBlockEntity.cooldown == 0 && state.method_11654(field_10920)) {
            super.method_9588(state, world, pos, random);
            amethystDispenserBlockEntity.cooldown = AmethystShield.CONFIG.dispenserNested.AMETHYST_DISPENSER_COOLDOWN();
            world.method_64311(pos, state.method_26204(), 1, class_1953.field_9314);
        } else {
            amethystDispenserBlockEntity.cooldown = Math.max(0, amethystDispenserBlockEntity.cooldown - 1);
            if (amethystDispenserBlockEntity.cooldown != 0) {
                world.method_64311(pos, state.method_26204(), 1, class_1953.field_9314);
            }
        }
    }

    @Override
    protected void method_10012(class_3218 world, class_2680 state, class_2338 pos) {
        AmethystDispenserBlockEntity dispenserBlockEntity = world.method_35230(pos, ModBlockEntities.AMETHYST_DISPENSER_BLOCK_ENTITY).orElse(null);
        if (dispenserBlockEntity == null) {
            AmethystShield.LOGGER.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", pos);
        } else {
            class_2342 blockPointer = new class_2342(world, pos, state, dispenserBlockEntity);
            int i = dispenserBlockEntity.method_11076(world.field_9229);
            if (i < 0) {
                world.method_20290(1001, pos, 0);
                world.method_43276(class_5712.field_28174, pos, class_5712.class_7397.method_43287(dispenserBlockEntity.method_11010()));
            } else {
                class_1799 itemStack = dispenserBlockEntity.method_5438(i);
                class_2357 dispenserBehavior = this.method_10011(world, itemStack);
                if (dispenserBehavior != class_2357.field_16902) {
                    dispenserBlockEntity.method_5447(i, dispenserBehavior.dispense(blockPointer, itemStack));
                }
            }
        }
    }
}
