package chaos.amyshield.datagen;

import chaos.amyshield.block.ModBlocks;
import chaos.amyshield.item.ModItems;
import chaos.amyshield.tag.ModTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class ModTagProvider {
    public static class ModItemTagProvider extends FabricTagProvider.ItemTagProvider {
        public ModItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        @Override
        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            valueLookupBuilder(ModTags.AMETHYST_SHIELD_ENCHANTABLE).method_71554(ModItems.AMETHYST_SHIELD);

            valueLookupBuilder(class_3489.field_48310).method_71554(ModItems.AMETHYST_SHIELD);

            valueLookupBuilder(ConventionalItemTags.SHIELD_TOOLS).method_71554(ModItems.AMETHYST_SHIELD);
        }
    }

    public static class ModEntityProvider extends FabricTagProvider.EntityTypeTagProvider {
        public ModEntityProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        @Override
        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            valueLookupBuilder(ModTags.SLASH_IMMUNE).method_71554(class_1299.field_59668);
        }
    }

    public static class ModBlockTagProvider extends FabricTagProvider.BlockTagProvider {
        public ModBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        @Override
        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            valueLookupBuilder(class_3481.field_33715)
                    .method_71554(ModBlocks.DIAMOND_DEPOSIT)
                    .method_71554(ModBlocks.AMETHYST_DISPENSER);

            valueLookupBuilder(ModTags.SHINY_ORES)
                    .method_71554(class_2246.field_10442)
                    .method_71554(class_2246.field_29029)

                    .method_71554(class_2246.field_10013)
                    .method_71554(class_2246.field_29220)

                    .method_71554(class_2246.field_10571)
                    .method_71554(class_2246.field_29026)

                    .method_71554(class_2246.field_10212)
                    .method_71554(class_2246.field_29027)

                    .method_71554(class_2246.field_10213)
                    .method_71554(class_2246.field_23880)
                    .method_71554(class_2246.field_22109)
                    .method_71554(class_2246.field_23077)

                    .method_71554(ModBlocks.DIAMOND_DEPOSIT);

        }
    }
}
