package chaos.amyshield.enchantments;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.item.ModItems;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ModEnchantments {
    public static final class_5321<class_1887> SENSITIVITY = of("sensitivity");
    public static final class_5321<class_1887> RELEASE = of("release");

    private static class_5321<class_1887> of(String path) {
        class_2960 id = class_2960.method_60655(AmethystShield.MOD_ID, path);
        return class_5321.method_29179(class_7924.field_41265, id);
    }

    public static int getReleaseEnchantmentLevel(class_1657 player) {
        List<class_1799> items = Stream.of(player.method_6079(), player.method_6047())
                .filter(stack -> stack.method_31574(ModItems.AMETHYST_SHIELD))
                .toList();

        if (items.isEmpty() || player.method_73183().method_30349().method_58561(ModEnchantments.RELEASE).isEmpty()) {
            return 1;
        }

        return class_1890.method_8225(player.method_73183().method_30349().method_58561(ModEnchantments.RELEASE).get(), items.getFirst()) + 1;
    }

    public static int getSensitivityEnchantmentLevel(class_1657 player) {
        List<class_1799> items = Stream.of(player.method_6079(), player.method_6047())
                .filter(stack -> stack.method_31574(ModItems.AMETHYST_SHIELD))
                .toList();

        if (items.isEmpty() || player.method_73183().method_30349().method_58561(ModEnchantments.SENSITIVITY).isEmpty()) {
            return 1;
        }

        return class_1890.method_8225(player.method_73183().method_30349().method_58561(ModEnchantments.SENSITIVITY).get(), items.getFirst()) + 1;
    }

    public static void init() {

    }
}
