package chaos.amyshield.item.custom;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.particles.ModParticles;
import chaos.amyshield.tag.ModTags;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class AmethystMonocleItem extends class_1792 {
    private int activationTimer = 0;

    public AmethystMonocleItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        return false;
    }

    /*
    @Override
    public ActionResult use(World world, PlayerEntity user, Hand hand) {
        if (user.getInventory().getArmorStack(3).getItem() == Items.AIR) {
            //user.getInventory().armor.set(3, user.getStackInHand(hand));
            user.equipStack(EquipmentSlot.HEAD, user.getStackInHand(hand));
            user.setStackInHand(hand, ItemStack.EMPTY);
            if (world.isClient()) {
                world.playSoundAtBlockCenter(user.getBlockPos(), SoundEvents.ITEM_ARMOR_EQUIP_GENERIC.value(), SoundCategory.PLAYERS, 1.0f, 1.0F, true);
            }
            return ActionResult.SUCCESS;
        }

        return super.use(world, user, hand);
    }

     */

    @Override
    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (slot == class_1304.field_6169) {
            if (this.activationTimer >= 1) {
                this.activationTimer--;
            } else {
                this.onPing(world, entity);
                this.activationTimer = AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_TIMER();
            }
        }

        super.method_7888(stack, world, entity, slot);
    }

    private void onPing(class_1937 world, class_1297 entity) {
        if (!(world instanceof class_3218 serverWorld) || !(entity instanceof class_3222 player)) {
            return;
        }

        for (class_2338 blockPos : class_2338.method_10097(
                entity.method_24515().method_10069(AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_RANGE(), AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_RANGE(), AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_RANGE()),
                entity.method_24515().method_10069(-AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_RANGE(), -AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_RANGE(), -AmethystShield.CONFIG.monocleNested.AMETHYST_MONOCLE_RANGE())))
        {
            class_2680 state = world.method_8320(blockPos);

            if (!state.method_26164(ModTags.SHINY_ORES)) {
                continue;
            }

            class_3959 context = new class_3959(
                    entity.method_73189().method_1031(0, 1, 0),
                    blockPos.method_46558(),
                    class_3959.class_3960.field_17559,
                    class_3959.class_242.field_1348,
                    entity
            );
            class_3965 result = world.method_17742(context);
            class_243 particlePos = result.method_17777().method_46558().method_43206(result.method_17780(), 0.51);
            class_2350 facing = result.method_17780();

            if (facing == class_2350.field_11039) {
                serverWorld.method_14166(player, ModParticles.AMETHYST_MONOCLE_PING_WEST, true, true, particlePos.method_10216(),  particlePos.method_10214(), particlePos.method_10215(), 1, 0, 0, 0, 0);
            } else if (facing == class_2350.field_11034) {
                serverWorld.method_14166(player, ModParticles.AMETHYST_MONOCLE_PING_EAST, true, true, particlePos.method_10216(),  particlePos.method_10214(), particlePos.method_10215(), 1, 0, 0, 0, 0);
            } else if (facing == class_2350.field_11043) {
                serverWorld.method_14166(player, ModParticles.AMETHYST_MONOCLE_PING_NORTH, true, true, particlePos.method_10216(),  particlePos.method_10214(), particlePos.method_10215(), 1, 0, 0, 0, 0);
            } else if (facing == class_2350.field_11035) {
                serverWorld.method_14166(player, ModParticles.AMETHYST_MONOCLE_PING_SOUTH, true, true, particlePos.method_10216(),  particlePos.method_10214(), particlePos.method_10215(), 1, 0, 0, 0, 0);
            } else if (facing == class_2350.field_11036) {
                serverWorld.method_14166(player, ModParticles.AMETHYST_MONOCLE_PING_UP, true, true, particlePos.method_10216(),  particlePos.method_10214(), particlePos.method_10215(), 1, 0, 0, 0, 0);
            } else if (facing == class_2350.field_11033) {
                serverWorld.method_14166(player, ModParticles.AMETHYST_MONOCLE_PING_DOWN, true, true, particlePos.method_10216(),  particlePos.method_10214(), particlePos.method_10215(), 1, 0, 0, 0, 0);
            }
        }
    }
}
