package chaos.amyshield.item.custom;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.enchantments.ModEnchantments;
import chaos.amyshield.networking.playload.SyncChargePayload;
import chaos.amyshield.networking.playload.SyncSlashPayload;
import chaos.amyshield.util.IEntityDataSaver;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1819;
import net.minecraft.class_3222;

public class AmethystShieldItem extends class_1819 {

    public AmethystShieldItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static float setCharge(IEntityDataSaver player, float amount) {
        IEntityDataSaver.AmethystShieldData nbt = player.amethyst_shield$getPersistentData();
        if (amount >= AmethystShield.CONFIG.amethystShieldNested.chargeNested.MAX_CHARGE()) {
            amount = AmethystShield.CONFIG.amethystShieldNested.chargeNested.MAX_CHARGE();
        }
        nbt.setCharge(amount);
        return amount;
    }

    public static void setSlashing(IEntityDataSaver player, boolean value) {
        IEntityDataSaver.AmethystShieldData nbt = player.amethyst_shield$getPersistentData();
        nbt.setSlashing(value);
    }

    public static boolean getSlashing(IEntityDataSaver player) {
        return player.amethyst_shield$getPersistentData().isSlashing();
    }

    public static void syncSlashing(boolean isSlashing) {
        ClientPlayNetworking.send(new SyncSlashPayload(isSlashing));
    }

    public static float addCharge(class_1657 player, float amount) {
        if (amount > 0) {

            int level = ModEnchantments.getSensitivityEnchantmentLevel(player);

            if (level > 0) {
                amount = amount * (level * AmethystShield.CONFIG.amethystShieldNested.enchantmentNested.CHARGE_GAIN_INCREASE_PER_LEVEL());
            }
        }

        IEntityDataSaver.AmethystShieldData nbt = ((IEntityDataSaver) player).amethyst_shield$getPersistentData();
        float charge = nbt.getCharge();
        if (charge + amount >= AmethystShield.CONFIG.amethystShieldNested.chargeNested.MAX_CHARGE()) {
            charge = AmethystShield.CONFIG.amethystShieldNested.chargeNested.MAX_CHARGE();
        } else if (charge + amount <= AmethystShield.CONFIG.amethystShieldNested.chargeNested.MIN_CHARGE()) {
            charge = AmethystShield.CONFIG.amethystShieldNested.chargeNested.MIN_CHARGE();
        } else {
            charge += amount;
        }
        nbt.setCharge(charge);
        return charge;
    }

    public static float getCharge(IEntityDataSaver player) {
        return player.amethyst_shield$getPersistentData().getCharge();
    }

    public static void syncCharge(float charge, class_3222 player) {
        ServerPlayNetworking.send(player, new SyncChargePayload(charge));
    }
}
