package chaos.amyshield.mixin;

import chaos.amyshield.block.ModBlocks;
import chaos.amyshield.block.blockEntities.custom.AmethystDispenserBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_9904;


@Mixin(class_2315.class)
public class AmethystDispenserConverterMixin extends class_2248 {
    @Shadow
    @Final
    public static class_2754<class_2350> FACING;

    public AmethystDispenserConverterMixin(class_2251 settings) {
        super(settings);
    }

    @Inject(method = "neighborUpdate", at = @At(value = "HEAD"))
    public void getStateForNeighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_9904 wireOrientation, boolean notify, CallbackInfo ci) {
        convertDispenserToAmethyst(state, world, pos, sourceBlock, wireOrientation, notify);
    }

    @Unique
    private static void convertDispenserToAmethyst(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_9904 wireOrientation, boolean notify) {
        class_2338 sourcePos = pos.method_10084();
        if (world.method_8320(sourcePos).method_26204() != class_2246.field_27161 || !world.method_8320(sourcePos).method_11654(FACING).equals(class_2350.field_11036) || !pos.equals(sourcePos.method_10074())) {
            return;
        }

        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2601) || blockEntity instanceof AmethystDispenserBlockEntity) {
            return;
        }

        Map<class_1799, Integer> itemStackMap = new java.util.HashMap<>(Map.of());
        for (int i = 0; i < ((class_2601) blockEntity).method_5439(); i++) {
            itemStackMap.put(((class_2601) blockEntity).method_5438(i), i);
        }

        ((class_2601) blockEntity).method_5448();
        world.method_8544(pos);
        world.method_8652(pos, ModBlocks.AMETHYST_DISPENSER.method_9564().method_11657(FACING, state.method_11654(FACING)), 3);
        class_2586 amethystblockEntity = world.method_8321(pos);
        if (amethystblockEntity instanceof AmethystDispenserBlockEntity) {
            amethystblockEntity.method_5431();
        }

        if (amethystblockEntity instanceof AmethystDispenserBlockEntity) {
            itemStackMap.forEach((stack, slot) -> ((AmethystDispenserBlockEntity) amethystblockEntity).method_5447(slot, stack));
        }
    }
}
