package chaos.amyshield.mixin;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.util.IEntityDataSaver;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_1309.class)
public class EntityDataSaverMixin implements IEntityDataSaver {
    @Unique
    private AmethystShieldData persistentData;

    @Override
    public AmethystShieldData amethyst_shield$getPersistentData() {
        if (this.persistentData == null) {
            this.persistentData = new AmethystShieldData();
        }
        return this.persistentData;
    }

    @WrapMethod(method = "writeCustomData")
    protected void injectWriteMethod(class_11372 writeView, Operation<Void> original) {
        if (this.persistentData != null) {
            writeView.method_71468(AmethystShield.MOD_ID, IEntityDataSaver.AMETHYST_SHIELD_DATA_CODEC, this.persistentData);
        }

        original.call(writeView);
    }

    @WrapMethod(method = "readCustomData")
    protected void injectReadMethod(class_11368 readView, Operation<Void> original) {
        this.persistentData = readView.method_71426(AmethystShield.MOD_ID, IEntityDataSaver.AMETHYST_SHIELD_DATA_CODEC).orElse(new AmethystShieldData());

        original.call(readView);
    }
}