package chaos.amyshield.mixin;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.item.custom.AmethystShieldItem;
import chaos.amyshield.util.IEntityDataSaver;
import net.minecraft.class_10707;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static chaos.amyshield.item.custom.AmethystShieldItem.syncCharge;

@Mixin(class_10707.class)
public class ShieldBrakeMixin {

    @Inject(method = "onShieldHit", at = @At("HEAD"))
    public void damageShield(class_1937 world, class_1799 stack, class_1309 entity, class_1268 hand, float amount, CallbackInfo ci) {
        if (entity instanceof class_1657 player) {
            if (!(player.method_6030().method_7909() instanceof class_1819)) {
                return;
            }
            if (!player.method_73183().method_8608()) {
                player.method_7259(class_3468.field_15372.method_14956(player.method_6030().method_7909()));
            }

            if (player.method_6030().method_7909() instanceof AmethystShieldItem) {
                double addedCharge = amount * AmethystShield.CONFIG.amethystShieldNested.chargeNested.BLOCK_GAIN_MULTIPLIER();
                AmethystShieldItem.addCharge((player), (float) addedCharge);
                syncCharge(AmethystShieldItem.getCharge(((IEntityDataSaver) player)), (class_3222) player);
            }
        }

//        if (amount <= 3.0f) {
//            return;
//        }
//
//        if (!player.getActiveItem().isEmpty()) {
//            return;
//        }
//
//        int i = 1 + MathHelper.floor(amount);
//        player.getActiveItem().damage(i, player.getActiveItem().getItem(), player, EquipmentSlot.OFFHAND);
//
//        if (hand == Hand.MAIN_HAND) {
//            player.equipStack(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
//        } else {
//            player.equipStack(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
//        }
//        player.clearActiveItem();
//        player.playSound(SoundEvents.ITEM_SHIELD_BREAK.value(), 0.8f, 0.8f + player.getWorld().random.nextFloat() * 0.4f);
    }
}
