package chaos.amyshield.mixin;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.enchantments.ModEnchantments;
import chaos.amyshield.item.custom.AmethystShieldItem;
import chaos.amyshield.particles.ModParticles;
import chaos.amyshield.tag.ModTags;
import chaos.amyshield.util.IEntityDataSaver;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

@Mixin(class_3222.class)
public class SlashingHitMixin {
    /*
    @Unique
    public int doomTimer = -1;
    @Unique
    public Entity otherDoomedPlayer;

     */

    @Inject(method = "tick", at = @At("HEAD"))
    protected void tickInject(CallbackInfo ci) {
        class_3222 player = (class_3222) (Object) this;
        /*
        if (doomTimer > -1) {
            doomTimer--;

            player.setPos(player.lastX, player.lastY, player.lastZ);
            player.fallDistance = 0;
            player.setVelocity(Vec3d.ZERO);
            player.velocityDirty = true;
        }

        if (doomTimer == 0 && otherDoomedPlayer != null) {
            player.setVelocity(player.getPos().subtract(otherDoomedPlayer.getPos()).normalize().multiply(10));
            player.velocityDirty = true;
        }

         */

        if (player != null && player.method_5805() && !player.method_31481() && !player.method_14239() && AmethystShieldItem.getSlashing(((IEntityDataSaver) player))) {
            if (player.method_59922().method_43048(5) == 1) {
                player.method_51469().method_65096(ModParticles.AMETHYST_CRIT_PARTICLE,
                        player.method_23317() + player.method_59922().method_43057() - 0.5,
                        player.method_23318() + player.method_59922().method_43057() - 0.5,
                        player.method_23321() + player.method_59922().method_43057() - 0.5,
                        1,
                        player.method_59922().method_43057(),
                        player.method_59922().method_43057(),
                        player.method_59922().method_43057(),
                        0);
                player.method_51469().method_8396(null, player.method_24515(), class_3417.field_26980, class_3419.field_15248, 1f, 1);
            }

            List<class_1297> entityList = new ArrayList<>(player.method_51469().method_8335(player, player.method_5829().method_1014(AmethystShield.CONFIG.amethystShieldNested.slashNested.SPARKLING_SLASH_RADIUS())));
            Objects.requireNonNull(player.method_51469().method_8503()).execute(() -> {
                for (class_1297 entity : entityList) {
                    if (entity instanceof class_1309 && !((class_1309) entity).method_29504() && !entity.method_31481() && !entity.method_5864().method_20210(ModTags.SLASH_IMMUNE)) {
                        /*
                        if (entity instanceof ServerPlayerEntity otherPlayer) {
                            if (otherPlayer != null && otherPlayer.isAlive() && !otherPlayer.isRemoved() && AmethystShieldItem.getSlashing(((IEntityDataSaver) otherPlayer))) {
                                doomTimer = 9;
                                player.getWorld().playSound(player, player.getPos().x, player.getPos().y, player.getPos().z, ModSounds.HYPER_EXPLOSION, SoundCategory.PLAYERS, 1.1f, 1f);
                                //AmethystShieldItem.setSlashing(((IEntityDataSaver) otherPlayer), false);
                                AmethystShieldItem.setSlashing(((IEntityDataSaver) player), false);
                                this.otherDoomedPlayer = otherPlayer;
                            }
                        }
                        */

                        if (entity.method_64397(player.method_51469(), player.method_48923().method_48815(player, player), (float) getSlashMultiplier(player))) {
                            AmethystShieldItem.addCharge((player), AmethystShield.CONFIG.amethystShieldNested.slashNested.SPARKLING_SLASH_CHARGE_RETURN());
                            AmethystShieldItem.syncCharge(AmethystShieldItem.getCharge(((IEntityDataSaver) player)), player);
                        }
                    }
                }
            });
        }
    }

    @Unique
    private static double getSlashMultiplier(class_1657 player) {
        return AmethystShield.CONFIG.amethystShieldNested.slashNested.SPARKLING_SLASH_DAMAGE() * (ModEnchantments.getReleaseEnchantmentLevel(player) * AmethystShield.CONFIG.amethystShieldNested.enchantmentNested.RELEASE_SLIDE_MULTIPLIER());
    }
}
