package chaos.amyshield.mixin.client;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.enchantments.ModEnchantments;
import chaos.amyshield.item.ModItems;
import chaos.amyshield.item.custom.AmethystShieldItem;
import chaos.amyshield.networking.playload.AmethystAbilityPayload;
import chaos.amyshield.networking.playload.AmethystPushPayload;
import chaos.amyshield.networking.playload.IgnoreFallDamagePayload;
import chaos.amyshield.util.IEntityDataSaver;
import chaos.amyshield.util.IMinecraftClientDatasaver;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Mixin(class_746.class)
public abstract class AmethystShieldAbilityClientMixin {
    //My stuff
    @Unique
    public int isDoubleJumpingTimer = 0;
    //for movement charge stuff
    @Unique
    public class_243 lastPos;
    @Unique
    public int movementChargeTimer = 0;
    @Unique
    public double movementCharge = 0;
    //double jump mod I ripped :)
    @Unique
    private boolean jumpedLastTick = false;
    @Unique
    private boolean isSliding = false;
    @Unique
    private boolean hasSneakedLastTick = false;
    @Unique
    private int sneakTimer = 0;
    @Unique
    private boolean hasBlockedLastTick = false;
    @Unique
    private int blockTimer = 0;

    @Unique
    private static boolean canUseAbility(class_746 player, float cost) {
        return AmethystShieldItem.getCharge(((IEntityDataSaver) player)) >= cost * -(1);
    }

    @Inject(at = @At("HEAD"), method = "tickMovement")
    public void tickMovement(CallbackInfo ci) {
        class_746 player = (class_746) (Object) this;

        this.gainMovementDeltaCharge();

        if ((player.method_24828() || player.method_6101() || player.method_31549().field_7479 || player.method_5681())) {
            if (this.isSliding) {
                this.isSliding = false;
            }

            if (AmethystShieldItem.getSlashing(((IEntityDataSaver) player))) {
                AmethystShieldItem.setSlashing(((IEntityDataSaver) player), false);
                AmethystShieldItem.syncSlashing(false);
            }
        }

        this.checkForSneaking();

        this.checkForBlocking();

        if (!player.method_24828() &&
                !player.method_6101() &&
                !this.jumpedLastTick &&
                !player.method_31549().field_7479) {

            if (canJump(player)) {
                //slashing code
                if (this.canUseSparklingSlash()) {
                    this.onSparklingSlash();
                }

                //double jumping code
                if (player.method_18798().method_10214() < 0f) {
                    if (this.isDoubleJumpingTimer >= 1) this.isDoubleJumpingTimer -= 1;
                    if (this.canDoubleJump()) {
                        this.onDoubleJump();
                    }
                }
            }
        }

        this.lastPos = player.method_73189();
        //IDK why I need this, but it was there from the Mod I riped it from
        this.jumpedLastTick = player.field_3913.field_54155.comp_3163();
    }

    @Unique
    private boolean canDoubleJump() {
        class_746 player = (class_746) (Object) this;

        return canUseAbility(player, AmethystShield.CONFIG.amethystShieldNested.doubleJumpNested.DOUBLE_JUMP_COST()) &&
                player.method_6039() &&
                player.field_3913.field_54155.comp_3163();
    }

    @Unique
    private boolean canUseSparklingSlash() {
        class_746 player = (class_746) (Object) this;

        return this.isDoubleJumpingTimer >= 1 &&
               ((IMinecraftClientDatasaver) class_310.method_1551()).amethyst_shield$getLastAttackTick() != 0 &&
               canUseAbility(player, AmethystShield.CONFIG.amethystShieldNested.slashNested.SPARKLING_SLASH_COST()) &&
               player.method_6047().method_31573(class_3489.field_48305);
    }

    @Unique
    public void checkForSneaking() {
        class_746 player = (class_746) (Object) this;

        if (this.sneakTimer >= 1) this.sneakTimer -= 1;

        if (player.method_5715()) {
            this.hasSneakedLastTick = true;
        }
        if (!player.method_5715() && this.hasSneakedLastTick) {
            this.hasSneakedLastTick = false;
            this.onSneakRelease();
        }
    }
    @Unique
    public void checkForBlocking() {
        class_746 player = (class_746) (Object) this;

        if (this.blockTimer >= 1) this.blockTimer -= 1;

        if (player.method_6115() && player.method_6030().method_7909().equals(ModItems.AMETHYST_SHIELD)) {
            this.hasBlockedLastTick = true;
        }

        if (!player.method_6115() && this.hasBlockedLastTick) {
            this.hasBlockedLastTick = false;
            this.onBlockRelease();
        }
    }

    @Unique
    private void gainMovementDeltaCharge() {
        this.tickMovementTimer();

        class_746 player = (class_746) (Object) this;

        if (this.lastPos == null || AmethystShieldItem.getSlashing(((IEntityDataSaver) player)) || this.isSliding || player.method_6128()) {
            return;
        }
        //movement delta
        double movementDelta = new class_241(((float) player.method_73189().method_10216()), ((float) player.method_73189().method_10215()))
                .method_35589(new class_241(((float) lastPos.method_10216()), ((float) lastPos.method_10215()))) * AmethystShield.CONFIG.amethystShieldNested.chargeNested.MOVEMENT_CHARGE_MULTIPLIER();

        if (movementDelta > AmethystShield.CONFIG.amethystShieldNested.chargeNested.MIN_MOVEMENT_DELTA()) {
            this.movementCharge += movementDelta;
        }
    }

    @Unique
    private void tickMovementTimer() {
        if (this.movementChargeTimer >= 1 && this.movementCharge < AmethystShield.CONFIG.amethystShieldNested.chargeNested.MAX_CHARGE() / 4) {
            this.movementChargeTimer -= 1;
        } else {
            if (this.movementCharge > 0) {
                this.onAbilityUse((float) this.movementCharge, false, false, false);
            }
            this.movementChargeTimer = AmethystShield.CONFIG.amethystShieldNested.chargeNested.MOVEMENT_CHARGE_TIMING();
            this.movementCharge = 0;
        }
    }

    @Unique
    private boolean canJump(class_746 player) {
        return !player.method_6128() && !player.method_5765()
                && !player.method_5799() && !player.method_6059(class_1294.field_5902);
    }

    @Unique
    private void onAbilityUse(float cost, boolean flatParticles, boolean notFlatParticles, boolean sound) {
        ClientPlayNetworking.send(new AmethystAbilityPayload(cost, flatParticles, notFlatParticles, sound));
    }

    @Unique
    public double getSparklingSlashMultiplier(class_1657 player) {
        double multiplier = AmethystShield.CONFIG.amethystShieldNested.slashNested.SPARKLING_SLASH_STRENGTH();

        return multiplier + (ModEnchantments.getReleaseEnchantmentLevel(player) * AmethystShield.CONFIG.amethystShieldNested.enchantmentNested.RELEASE_SPARKLING_SLASH_MULTIPLIER());
    }

    @Unique
    private void onSparklingSlash() {
        class_746 player = (class_746) (Object) this;
        AmethystShieldItem.setSlashing(((IEntityDataSaver) player), true);
        AmethystShieldItem.syncSlashing(true);

        flingPlayer(getSparklingSlashMultiplier(player));
        this.isDoubleJumpingTimer = 0;

        player.field_49989 = player.method_73189();
        player.method_60984(true);
        ClientPlayNetworking.send(new IgnoreFallDamagePayload(player.method_73189().method_1023(0, 1000, 0)));

        this.onAbilityUse(AmethystShield.CONFIG.amethystShieldNested.slashNested.SPARKLING_SLASH_COST(), false, true, true);
    }

    @Unique
    public double getDoubleJumpMultiplier(class_1657 player) {
        double multiplier = AmethystShield.CONFIG.amethystShieldNested.doubleJumpNested.DOUBLE_JUMP_STRENGTH();

        return multiplier + (ModEnchantments.getReleaseEnchantmentLevel(player) * AmethystShield.CONFIG.amethystShieldNested.enchantmentNested.RELEASE_DOUBLE_JUMP_MULTIPLIER());
    }

    @Unique
    private void onDoubleJump() {
        class_746 player = (class_746) (Object) this;

        for (class_1799 itemStack : List.of(player.method_6079(), player.method_6047())) {
            class_1792 shield = itemStack.method_7909();

            if (shield != ModItems.AMETHYST_SHIELD) {
                continue;
            }

            player.method_6043();
            player.method_18800(player.method_18798().method_10216(), getDoubleJumpMultiplier(player) , player.method_18798().method_10215());

            this.isDoubleJumpingTimer = AmethystShield.CONFIG.amethystShieldNested.slashNested.SLASH_TIMING();

            player.field_49989 = player.method_73189();
            player.method_60984(true);
            ClientPlayNetworking.send(new IgnoreFallDamagePayload(player.method_73189()));

            this.onAbilityUse(AmethystShield.CONFIG.amethystShieldNested.doubleJumpNested.DOUBLE_JUMP_COST(), true, false, true);
            return;
        }
    }

    @Unique
    private void onAmethystBurst() {
        ClientPlayNetworking.send(new AmethystPushPayload(true));
        this.onAbilityUse(AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_COST(), true, false, true);
    }

    @Unique
    private void onSneakRelease() {
        class_746 player = (class_746) (Object) this;
        if (!player.method_6039()) {
            return;
        }

        if (this.sneakTimer >= 1) {
            this.sneakTimer = 0;
            if (canUseAbility(player, AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_COST())) {
                this.onAmethystBurst();
            }
            return;
        }
        this.sneakTimer = AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_SNEAKING_TIMING();
    }

    @Unique
    private void onBlockRelease() {
        class_746 player = (class_746) (Object) this;
        if (this.blockTimer >= 1) {
            this.blockTimer = 0;
            if (canUseAbility(player, AmethystShield.CONFIG.amethystShieldNested.slideNested.AMETHYST_SLIDE_COST())) {
                this.onAmethystSlide();
            }
            return;
        }
        this.blockTimer = AmethystShield.CONFIG.amethystShieldNested.slideNested.AMETHYST_SLIDE_TIMING();
    }

    @Unique
    private void onAmethystSlide() {
        this.applyMovementVelocity();
        this.isSliding = true;
        this.onAbilityUse(AmethystShield.CONFIG.amethystShieldNested.slideNested.AMETHYST_SLIDE_COST(), true, false, true);
    }

    @Unique
    public double getSlideMultiplier(class_1657 player) {
        return ModEnchantments.getReleaseEnchantmentLevel(player) * AmethystShield.CONFIG.amethystShieldNested.enchantmentNested.RELEASE_SLIDE_MULTIPLIER();
    }

    @Unique
    public void applyMovementVelocity() {
        class_746 player = (class_746) (Object) this;
        // Get the player's current direction vector
        class_243 facing = player.method_5828(1.0F);

        // Initialize movement vector
        class_243 movement = class_243.field_1353;

        // Get movement inputs
        boolean forward = player.field_3913.field_54155.comp_3159();
        boolean back = player.field_3913.field_54155.comp_3160();
        boolean left = player.field_3913.field_54155.comp_3161();
        boolean right = player.field_3913.field_54155.comp_3162();

        if (!back && !left && !forward && !right) {
            forward = true;
        }
        // Calculate movement direction
        if (forward) {
            movement = movement.method_1019(facing);
        }
        if (back) {
            movement = movement.method_1019(facing.method_22882());
        }
        if (left) {
            movement = movement.method_1019(facing.method_1024((float) Math.toRadians(90)));
        }
        if (right) {
            movement = movement.method_1019(facing.method_1024((float) Math.toRadians(-90)));
        }

        // Normalize movement vector
        if (movement.method_1027() > 0) {
            movement = movement.method_1029();
        }
        movement = movement.method_1021(2 + getSlideMultiplier(player));

        // Apply velocity to the player
        player.method_5668().method_18800(movement.field_1352 + player.method_18798().field_1352, player.method_18798().method_10214() * 0.5, movement.field_1350 + player.method_18798().field_1350);
    }

    //chatGPTs code since IDK math like that
    @Unique
    private void flingPlayer(double speed) {
        class_746 player = (class_746) (Object) this;
        float yaw = player.method_36454();
        float pitch = player.method_36455();

        // Convert yaw and pitch to radians
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);

        // Calculate velocity components
        double vx = -Math.sin(yawRadians) * Math.cos(pitchRadians) * speed;
        double vy = -Math.sin(pitchRadians) * speed;
        double vz = Math.cos(yawRadians) * Math.cos(pitchRadians) * speed;

        // Apply velocity to the player
        player.method_18800(player.method_18798().method_10216() + vx,
                player.method_18798().method_10214() + vy,
                player.method_18798().method_10215() + vz);
    }
}