package chaos.amyshield.networking.C2Server;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.enchantments.ModEnchantments;
import chaos.amyshield.item.ModItems;
import chaos.amyshield.networking.playload.AmethystPushPayload;
import chaos.amyshield.networking.playload.IgnoreFallDamagePayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6088;
import org.spongepowered.asm.mixin.Unique;

import java.util.ArrayList;
import java.util.List;

public class AmethystPushAbilityPacketC2S {
    public static void push(AmethystPushPayload _payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            for (class_1799 itemStack : List.of(context.player().method_6047(), context.player().method_6079())) {
                class_1792 shield = itemStack.method_7909();
                if (shield == ModItems.AMETHYST_SHIELD) {
                    class_3414 soundEvent = context.player().field_6017 > 5.0 ? class_3417.field_49924 : class_3417.field_49785;
                    context.player().method_51469().method_43128(null, context.player().method_23317(), context.player().method_23318(), context.player().method_23321(), soundEvent, context.player().method_5634(), 1.0F, 1.0F);

                    class_243 vec3d = context.player().method_73189();
                    int i = (int) class_3532.method_15350(50.0, 0.0, 200.0);
                    context.player().method_51469().method_65096(new class_2388(class_2398.field_11217, context.player().method_25936()), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, i, 0.30000001192092896, 0.30000001192092896, 0.30000001192092896, 0.15000000596046448);
                    context.player().method_51469().method_20290(class_6088.field_50168, context.player().method_23312(), 750);

                    List<class_1297> entityList = new ArrayList<>(getEntitiesAroundPlayer(AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_RADIUS(), context.player()));
                    if (AmethystShield.CONFIG.amethystShieldNested.pushNested.KILL_ONLY_HOSTILE()) {
                        entityList = entityList.stream().filter((entity) -> entity instanceof class_1569 || entity instanceof class_1657).toList();
                    }

                    for (class_1297 entity : entityList) {
                        if (entity instanceof class_1309 && !((class_1309) entity).method_29504() && !entity.method_31481()) {
                            pushEntityAwayFromPlayer(entity, AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_STRENGTH_X() * getBurstMultiplier(context.player()), context.player());
                            entity.method_64397(context.player().method_51469(), context.player().method_48923().method_48815(context.player(), context.player()), (float) (AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_DAMAGE() * getBurstMultiplier(context.player())));
                        }
                    }

                    return;
                }
            }
        });
    }

    @Unique
    public static double getBurstMultiplier(class_1657 player) {
        return (ModEnchantments.getReleaseEnchantmentLevel(player) * AmethystShield.CONFIG.amethystShieldNested.enchantmentNested.RELEASE_PUSH_MULTIPLIER());
    }

    private static List<class_1297> getEntitiesAroundPlayer(double radius, class_1657 player) {
        class_1937 world = player.method_73183();
        class_238 box = new class_238(
                player.method_23317() - radius, player.method_23318() - radius, player.method_23321() - radius,
                player.method_23317() + radius, player.method_23318() + radius, player.method_23321() + radius
        );
        return world.method_8335(player, box);
    }

    private static void pushEntityAwayFromPlayer(class_1297 entity, double speed, class_1657 player) {
        class_241 playerPos = new class_241((float) -player.method_73189().method_10216(), (float) -player.method_73189().method_10215());
        class_241 entityPos = new class_241((float) entity.method_73189().method_10216(), (float) entity.method_73189().method_10215());
        class_241 direction = entityPos.method_35586(playerPos);

        class_241 normalizedDirection = direction.method_35581();

        class_241 velocity = normalizedDirection.method_35582((float) (speed + (player.method_5739(entity) * 0.8)));

        entity.method_60491(new class_243(velocity.field_1343, AmethystShield.CONFIG.amethystShieldNested.pushNested.AMETHYST_PUSH_STRENGTH_Y() * getBurstMultiplier(player), velocity.field_1342));
    }

    public static void ignoreFallDamage(IgnoreFallDamagePayload ignoreFallDamagePayload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            for (class_1799 itemStack : List.of(context.player().method_6047(), context.player().method_6079())) {
                class_1792 shield = itemStack.method_7909();
                if (shield == ModItems.AMETHYST_SHIELD) {
                    class_3222 player = context.player();

                    if (player.field_49989 != null) {
                        if (player.field_49989.field_1351 > ignoreFallDamagePayload.till().field_1351) {
                            return;
                        }
                    }
                    player.field_49989 = ignoreFallDamagePayload.till();
                    player.method_60984(true);
                }
            }
        });
    }
}