package chaos.amyshield.networking.C2Server;

import chaos.amyshield.item.ModItems;
import chaos.amyshield.item.custom.AmethystShieldItem;
import chaos.amyshield.networking.playload.AmethystAbilityPayload;
import chaos.amyshield.particles.ModParticles;
import chaos.amyshield.util.IEntityDataSaver;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.List;

import static chaos.amyshield.item.custom.AmethystShieldItem.syncCharge;

public class AmethystShieldAbilityPacketC2S {
    public static void setChargeAndSpawnParticle(AmethystAbilityPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        for (class_1799 itemStack : List.of(player.method_6047(), player.method_6079())) {
            class_1792 shield = itemStack.method_7909();
            if (shield == ModItems.AMETHYST_SHIELD) {
                if (payload.sound()) {
                    player.method_51469().method_8396(null, player.method_24515(), class_3417.field_17265, class_3419.field_15248, 0.2F, 1.0F);
                    player.method_51469().method_8396(null, player.method_24515(), class_3417.field_19167, class_3419.field_15248, 0.2F, 1.0F);
                    player.method_51469().method_8396(null, player.method_24515(), class_3417.field_26980, class_3419.field_15248, 1.5f, 1.0F);
                }
                if (payload.flatParticles()) {
                    player.method_51469().method_65096(ModParticles.AMETHYST_CHARGE_PARTICLE_FLAT, player.method_23317(), player.method_23318() + 1, player.method_23321(), 1, 0, 0, 0, 0);
                }
                if (payload.notFlatParticles()) {
                    player.method_51469().method_65096(ModParticles.AMETHYST_CHARGE_PARTICLE, player.method_23317(), player.method_23318() + 1, player.method_23321(), 1, 0, 0, 0, 0);
                }

                AmethystShieldItem.addCharge((player), payload.chargeAmount());
                syncCharge(AmethystShieldItem.getCharge(((IEntityDataSaver) player)), player);
                return;
            }
        }
    }
}
