package chaos.amyshield.particles.custom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11944;
import net.minecraft.class_2400;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class AmethystChargeParticle extends class_3940 {
    private final class_4002 spriteProvider;
    private final boolean isFlat;

    protected AmethystChargeParticle(class_638 world, double x, double y, double z, class_4002 spriteProvider, boolean isFlat) {
        super(world, x, y, z, spriteProvider.method_74304());

        this.isFlat = isFlat;
        this.field_3866 = 0;
        this.spriteProvider = spriteProvider;
        this.field_3847 = 12;
        this.field_17867 = 2F;
    }

    @Override
    protected void method_60375(class_11944 submittable, Quaternionf rotation, float x, float y, float z, float tickProgress) {
        if (this.isFlat) {
            super.method_60375(submittable, new Quaternionf(-1,0,0,1), x, y, z, tickProgress);
            super.method_60375(submittable, new Quaternionf(1,0,0,1), x, y, z, tickProgress);
            return;
        }

        super.method_60375(submittable, rotation, x, y, z, tickProgress);
    }

    @Override
    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_74306(this.spriteProvider);
        }
    }

    @Override
    protected class_11941 method_74255() {
        return class_11941.field_62640;
    }

    @Environment(EnvType.CLIENT)
    public static class Factory implements class_707<class_2400> {
        private final class_4002 spriteProvider;
        private final boolean isFlat;

        public Factory(class_4002 spriteProvider, boolean isFlat) {
            this.spriteProvider = spriteProvider;
            this.isFlat = isFlat;
        }

        @Override
        public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_5819 random) {
            return new AmethystChargeParticle(world, x, y, z, this.spriteProvider, this.isFlat);
        }
    }
}
