package chaos.amyshield.ui.client;

import chaos.amyshield.AmethystShield;
import chaos.amyshield.item.ModItems;
import chaos.amyshield.util.IEntityDataSaver;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_746;
import net.minecraft.class_9779;

public class ChargeHudOverlay implements HudElement {
    private static final class_2960 CHARGE_UI_ATLAS = class_2960.method_60655(AmethystShield.MOD_ID, "hud/amethyst_shield_ui");

    @Override
    public void render(class_332 drawContext, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1690.field_1842) {
            return;
        }

        if (client.field_1724 == null ||client.field_1724.method_7325()) {
            return;
        }
        class_746 player = client.field_1724;

        if (!player.method_6047().method_7909().equals(ModItems.AMETHYST_SHIELD) &&
                !player.method_6079().method_7909().equals(ModItems.AMETHYST_SHIELD)) {
            return;
        }

        class_10209.method_64146().method_15405("charge");

        int width = drawContext.method_51421();
        int height = drawContext.method_51443();
        int x = width / 2;
        int y = height;

        int yshift = 53 + AmethystShield.CONFIG.amethystShieldNested.CHARGE_BAR_OFFSET();
        int maxAir = player.method_5748();
        int playerAir = Math.min(player.method_5669(), maxAir);
        if (player.method_31549().field_7477) yshift -= 17;
        if ((player.method_5777(class_3486.field_15517) || playerAir < maxAir) && !player.method_31549().field_7477) yshift += 10;
        class_1309 livingEntity = this.getRiddenEntity();

        if (livingEntity != null) {
            int i = this.getHeartCount(livingEntity);
            if (i > 10) {
                yshift += 10;
            }
            if (player.method_31549().field_7477) yshift += 17;
        }

        drawContext.method_70846(class_10799.field_56883, CHARGE_UI_ATLAS,
                81,
                18,
                1,
                15,
                x + 11,
                y - yshift + 5,
                (int) (79f * ((((IEntityDataSaver) player).amethyst_shield$getPersistentData().getCharge())
                / AmethystShield.CONFIG.amethystShieldNested.chargeNested.MAX_CHARGE())),
                3);

        drawContext.method_70846(class_10799.field_56883, CHARGE_UI_ATLAS,
                81,
                18,
                0,
                0,
                x + 10,
                y - yshift,
                81,
                13);


        class_10209.method_64146().method_15407();
    }

    private class_1309 getRiddenEntity() {
        class_1657 playerEntity = this.getCameraPlayer();
        if (playerEntity == null) {
            return null;
        }

        class_1297 entity = playerEntity.method_5854();
        if (entity == null) {
            return null;
        }

        if (entity instanceof class_1309) {
            return (class_1309) entity;
        }

        return null;
    }

    private int getHeartCount(class_1309 entity) {
        if (entity == null || !entity.method_5709()) {
            return 0;
        }

        float f = entity.method_6063();
        int i = (int) (f + 0.5f) / 2;
        if (i > 30) {
            i = 30;
        }
        return i;
    }

    private class_1657 getCameraPlayer() {
        if (!(class_310.method_1551().method_1560() instanceof class_1657)) {
            return null;
        }
        return (class_1657) class_310.method_1551().method_1560();
    }
}
