/*
 * Decompiled with CFR 0.152.
 */
package com.everlastingutils.config;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/everlastingutils/config/JsoncParser;", "", "<init>", "()V", "", "content", "Lkotlin/Pair;", "", "parseWithComments", "(Ljava/lang/String;)Lkotlin/Pair;", "", "comments", "removeComments", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "", "index", "", "isEscaped", "(Ljava/lang/String;I)Z", "extractConfigSection", "(Ljava/lang/String;)Ljava/lang/String;", "Companion", "everlastingutils"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\ncom/everlastingutils/config/JsoncParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1#2:538\n*E\n"})
public final class JsoncParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex TRAILING_COMMA = new Regex(",(\\s*[}\\]])");

    @NotNull
    public final Pair<String, Map<String, String>> parseWithComments(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Map comments = new LinkedHashMap();
        String jsonContent = this.removeComments(content, comments);
        CharSequence charSequence = jsonContent;
        Regex regex = TRAILING_COMMA;
        String string = "$1";
        String processedContent = regex.replace(charSequence, string);
        return TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)processedContent)).toString(), (Object)comments);
    }

    private final String removeComments(String content, Map<String, String> comments) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        boolean inString = false;
        int commentStart = -1;
        String propertyBeforeComment = "";
        while (i < content.length()) {
            char c = content.charAt(i);
            if (inString) {
                result.append(c);
                if (c == '\"' && !this.isEscaped(content, i)) {
                    inString = false;
                }
                ++i;
                continue;
            }
            if (c == '\"' && !this.isEscaped(content, i)) {
                inString = true;
                result.append(c);
                ++i;
                continue;
            }
            if (c == '/' && i + 1 < content.length() && content.charAt(i + 1) == '/') {
                commentStart = i;
                int it = StringsKt.indexOf$default((CharSequence)content, (char)'\n', (int)i, (boolean)false, (int)4, null);
                boolean bl = false;
                int commentEnd = it == -1 ? content.length() : it;
                String string = content.substring(i + 2, commentEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String commentText = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!StringsKt.isBlank((CharSequence)propertyBeforeComment)) {
                    comments.put(propertyBeforeComment, commentText);
                }
                if ((i = commentEnd) >= content.length()) continue;
                result.append('\n');
                ++i;
                continue;
            }
            if (c == '/' && i + 1 < content.length() && content.charAt(i + 1) == '*') {
                commentStart = i;
                int commentEnd = StringsKt.indexOf$default((CharSequence)content, (String)"*/", (int)(i + 2), (boolean)false, (int)4, null);
                if (commentEnd != -1) {
                    i = commentEnd + 2;
                    continue;
                }
                i = content.length();
                continue;
            }
            result.append(c);
            if (c == ':' && commentStart == -1) {
                String string = result.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String lineSoFar = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String lastProperty = StringsKt.removeSurrounding((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringBeforeLast((String)StringsKt.substringAfterLast((String)lineSoFar, (char)'\"', (String)""), (char)':', (String)""))).toString(), (CharSequence)"\"");
                if (!StringsKt.isBlank((CharSequence)lastProperty)) {
                    propertyBeforeComment = lastProperty;
                }
            }
            ++i;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isEscaped(String content, int index) {
        int count = 0;
        for (int j = index - 1; j >= 0 && content.charAt(j) == '\\'; --j) {
            ++count;
        }
        return count % 2 != 0;
    }

    @Nullable
    public final String extractConfigSection(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Regex CONFIG_SECTION = new Regex("\\/\\*\\s*CONFIG_SECTION\\s*\\*\\/([\\s\\S]*?)(?:\\/\\*\\s*END_CONFIG_SECTION\\s*\\*\\/|$)");
        Object object = Regex.find$default((Regex)CONFIG_SECTION, (CharSequence)content, (int)0, (int)2, null);
        return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/everlastingutils/config/JsoncParser$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "TRAILING_COMMA", "Lkotlin/text/Regex;", "everlastingutils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

