/*
 * Decompiled with CFR 0.152.
 */
package com.everlastingutils.scheduling;

import com.everlastingutils.utils.LogDebugKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJG\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J?\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u0019\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0004\b\"\u0010#R\u001c\u0010&\u001a\n %*\u0004\u0018\u00010$0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R*\u0010,\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130+0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010*\u00a8\u0006-"}, d2={"Lcom/everlastingutils/scheduling/SchedulerManager;", "", "<init>", "()V", "", "id", "Ljava/util/concurrent/ScheduledExecutorService;", "createScheduler", "(Ljava/lang/String;)Ljava/util/concurrent/ScheduledExecutorService;", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialDelay", "period", "Ljava/util/concurrent/TimeUnit;", "unit", "Lkotlin/Function0;", "", "task", "Ljava/util/concurrent/ScheduledFuture;", "scheduleAtFixedRate", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;JJLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function0;)Ljava/util/concurrent/ScheduledFuture;", "delay", "schedule", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;JLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function0;)Ljava/util/concurrent/ScheduledFuture;", "", "mayInterruptIfRunning", "cancelTasks", "(Ljava/lang/String;Z)V", "shutdown", "(Ljava/lang/String;)V", "shutdownAll", "", "", "getStats", "()Ljava/util/Map;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "schedulers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "tasks", "everlastingutils"})
@SourceDebugExtension(value={"SMAP\nSchedulerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedulerManager.kt\ncom/everlastingutils/scheduling/SchedulerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,150:1\n1863#2,2:151\n1863#2,2:153\n1246#2,4:157\n462#3:155\n412#3:156\n*S KotlinDebug\n*F\n+ 1 SchedulerManager.kt\ncom/everlastingutils/scheduling/SchedulerManager\n*L\n112#1:151,2\n136#1:153,2\n148#1:157,4\n148#1:155\n148#1:156\n*E\n"})
public final class SchedulerManager {
    @NotNull
    public static final SchedulerManager INSTANCE = new SchedulerManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"EverlastingUtils-SchedulerManager");
    @NotNull
    private static final ConcurrentHashMap<String, ScheduledExecutorService> schedulers = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, List<ScheduledFuture<?>>> tasks = new ConcurrentHashMap();

    private SchedulerManager() {
    }

    @NotNull
    public final ScheduledExecutorService createScheduler(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ScheduledExecutorService scheduledExecutorService = schedulers.computeIfAbsent(id, arg_0 -> SchedulerManager.createScheduler$lambda$2(arg_0 -> SchedulerManager.createScheduler$lambda$1(id, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"computeIfAbsent(...)");
        return scheduledExecutorService;
    }

    @NotNull
    public final ScheduledFuture<?> scheduleAtFixedRate(@NotNull String id, @NotNull MinecraftServer server, long initialDelay, long period, @NotNull TimeUnit unit, @NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        ScheduledExecutorService scheduler = this.createScheduler(id);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(() -> SchedulerManager.scheduleAtFixedRate$lambda$4(server, id, task), initialDelay, period, unit);
        Intrinsics.checkNotNull(future);
        tasks.computeIfAbsent(id, arg_0 -> SchedulerManager.scheduleAtFixedRate$lambda$6(SchedulerManager::scheduleAtFixedRate$lambda$5, arg_0)).add(future);
        return future;
    }

    @NotNull
    public final ScheduledFuture<?> schedule(@NotNull String id, @NotNull MinecraftServer server, long delay, @NotNull TimeUnit unit, @NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        ScheduledExecutorService scheduler = this.createScheduler(id);
        ScheduledFuture<?> future = scheduler.schedule(() -> SchedulerManager.schedule$lambda$8(server, id, task), delay, unit);
        Intrinsics.checkNotNull(future);
        tasks.computeIfAbsent(id, arg_0 -> SchedulerManager.schedule$lambda$10(SchedulerManager::schedule$lambda$9, arg_0)).add(future);
        return future;
    }

    public final void cancelTasks(@NotNull String id, boolean mayInterruptIfRunning) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<ScheduledFuture<?>> list = tasks.get(id);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScheduledFuture future = (ScheduledFuture)element$iv;
                boolean bl = false;
                future.cancel(mayInterruptIfRunning);
            }
        }
        List<ScheduledFuture<?>> list2 = tasks.get(id);
        if (list2 != null) {
            list2.clear();
        }
        LogDebugKt.logDebug("[SCHEDULER] Cancelled all tasks for scheduler: " + id, "everlastingutils");
    }

    public static /* synthetic */ void cancelTasks$default(SchedulerManager schedulerManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schedulerManager.cancelTasks(string, bl);
    }

    public final void shutdown(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SchedulerManager.cancelTasks$default(this, id, false, 2, null);
        ScheduledExecutorService scheduledExecutorService = schedulers.get(id);
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdown();
        }
        schedulers.remove(id);
        LogDebugKt.logDebug("[SCHEDULER] Shut down scheduler: " + id, "everlastingutils");
    }

    public final void shutdownAll() {
        Enumeration<String> enumeration = schedulers.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        ArrayList<String> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        List allIds = arrayList;
        Iterable $this$forEach$iv = allIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)id);
            INSTANCE.shutdown(id);
        }
        LogDebugKt.logDebug("[SCHEDULER] Shut down all schedulers", "everlastingutils");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getStats() {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = tasks;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Integer n = ((List)it.getValue()).size();
            map3.put(k, n);
        }
        return destination$iv$iv;
    }

    private static final Thread createScheduler$lambda$1$lambda$0(String $id, Runnable r) {
        Thread thread = new Thread(r, "everlastingUtils-Scheduler-" + $id);
        thread.setDaemon(true);
        return thread;
    }

    private static final ScheduledExecutorService createScheduler$lambda$1(String $id, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LogDebugKt.logDebug("[SCHEDULER] Creating new scheduler: " + $id, "everlastingutils");
        return Executors.newSingleThreadScheduledExecutor(arg_0 -> SchedulerManager.createScheduler$lambda$1$lambda$0($id, arg_0));
    }

    private static final ScheduledExecutorService createScheduler$lambda$2(Function1 $tmp0, Object p0) {
        return (ScheduledExecutorService)$tmp0.invoke(p0);
    }

    private static final void scheduleAtFixedRate$lambda$4$lambda$3(Function0 $task) {
        $task.invoke();
    }

    private static final void scheduleAtFixedRate$lambda$4(MinecraftServer $server, String $id, Function0 $task) {
        try {
            $server.method_40000(() -> SchedulerManager.scheduleAtFixedRate$lambda$4$lambda$3($task));
        }
        catch (Exception e) {
            logger.error("Error executing scheduled task in " + $id + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static final List scheduleAtFixedRate$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        return CollectionsKt.toMutableList((Collection)keySetView);
    }

    private static final List scheduleAtFixedRate$lambda$6(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void schedule$lambda$8$lambda$7(Function0 $task) {
        $task.invoke();
    }

    private static final void schedule$lambda$8(MinecraftServer $server, String $id, Function0 $task) {
        try {
            $server.method_40000(() -> SchedulerManager.schedule$lambda$8$lambda$7($task));
        }
        catch (Exception e) {
            logger.error("Error executing scheduled task in " + $id + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static final List schedule$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        return CollectionsKt.toMutableList((Collection)keySetView);
    }

    private static final List schedule$lambda$10(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

