package de.kaama.mobcapture.enchantment.effect;

//? if >=1.21 {

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.kaama.mobcapture.MobCaptureMod;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_9699;
import net.minecraft.class_9704;
import net.minecraft.class_9721;

public record CapturingEnchantmentEffect(
        class_9704 dropChanceValue) implements class_9721 {
    public static final MapCodec<CapturingEnchantmentEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_9704.field_51690.fieldOf("drop_chance_value").forGetter(CapturingEnchantmentEffect::dropChanceValue)).apply(instance, CapturingEnchantmentEffect::new));

    @Override
    public void method_60220(class_3218 world, int level, class_9699 context, class_1297 target, class_243 pos) {
        if (!(context.comp_2684() instanceof class_1657 && target instanceof class_1309 victim && victim.method_29504()))
            return;

        if (victim instanceof class_1657 || isBossEntity(victim.method_5864()))
            return;

        var random = world.method_8409();
        var baseDropChance = dropChanceValue.method_60188(level);

        var difficulty = world.method_8407();
        var difficultyMultiplier = switch (difficulty) {
            case field_5801 -> 1.5f;
            case field_5805 -> 1.25f;
            case field_5802 -> 1.0f;
            case field_5807 -> 0.75f;
        };

        var spawnGroup = victim.method_5864().method_5891();
        var spawnGroupMultiplier = switch (spawnGroup) {
            case field_6302 -> 1.0f;
            case field_6294, field_6300, field_34447, field_30092 -> 0.6f;
            case field_6303, field_24460 -> 0.35f;
            case field_17715 -> 0.2f;
        };

        var adjustedDropChance = Math.clamp(baseDropChance * difficultyMultiplier * spawnGroupMultiplier, 0.005f, 0.20f);

        if (random.method_43057() < adjustedDropChance)
            trySpawnEgg(world, victim);
    }

    /**
     * Helper method to determine if an EntityType is a "boss".
     */
    private boolean isBossEntity(class_1299<?> type) {
        return type.equals(class_1299.field_6116) || type.equals(class_1299.field_6119) || type.equals(class_1299.field_6086);
    }

    /**
     * Attempts to create and drop a spawn egg at the victim's location.
     */
    private void trySpawnEgg(class_3218 world, class_1309 victim) {
        if (world.method_8608()) return;

        class_1826 spawnEgg = class_1826.method_8019(victim.method_5864());

        if (spawnEgg != null) {
            class_1799 spawnEggStack = new class_1799(spawnEgg);
            class_1542 itemEntity = new class_1542(world, victim.method_23317(), victim.method_23318(), victim.method_23321(), spawnEggStack);
            world.method_8649(itemEntity);
        } else {
            MobCaptureMod.LOGGER.debug("No spawn egg found for entity type: {}", victim.method_5864().method_5897().getString());
        }
    }

    @Override
    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }
}
//?}