package net.kronoz.odyssey;

import eu.midnightdust.lib.config.MidnightConfig;
import foundry.veil.api.client.render.VeilRenderSystem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.kronoz.odyssey.block.custom.SimpleBlockLightManager;
import net.kronoz.odyssey.block.custom.StasisPodBERenderer;
import net.kronoz.odyssey.client.ClientElevatorAssist;
import net.kronoz.odyssey.config.OdysseyConfig;
import net.kronoz.odyssey.entity.*;
import net.kronoz.odyssey.entity.apostasy.ApostasyRenderer;
import net.kronoz.odyssey.entity.apostasy.ApostasyThemeClient;
import net.kronoz.odyssey.entity.arcangel.ArcangelRenderer;
import net.kronoz.odyssey.entity.projectile.LaserProjectileEntity;
import net.kronoz.odyssey.entity.projectile.LaserProjectileRenderer;
import net.kronoz.odyssey.entity.sentinel.SentinelLightClient;
import net.kronoz.odyssey.entity.sentinel.SentinelRenderer;
import net.kronoz.odyssey.entity.sentry.SentryRenderer;
import net.kronoz.odyssey.entity.souls.LoveRenderer;
import net.kronoz.odyssey.entity.thrasher.ThrasherRenderer;
import net.kronoz.odyssey.hud.bosshud.BossHudClient;
import net.kronoz.odyssey.hud.death.DeathUICutscene;
import net.kronoz.odyssey.init.*;
import net.kronoz.odyssey.movement.WallRun;
import net.kronoz.odyssey.movement.WallRunLoopSound;
import net.kronoz.odyssey.net.BossHudClearPayload;
import net.kronoz.odyssey.net.BossHudUpdatePayload;
import net.kronoz.odyssey.net.CineNetworking;
import net.kronoz.odyssey.particle.SentryShieldFullParticle;
import net.kronoz.odyssey.particle.SliceParticle;
import net.kronoz.odyssey.systems.cam.ShakeEvents;
import net.kronoz.odyssey.systems.cinematics.runtime.BootstrapScenes;
import net.kronoz.odyssey.systems.cinematics.runtime.CutsceneManager;
import net.kronoz.odyssey.systems.dialogue.client.DialogueClient;
import net.kronoz.odyssey.systems.physics.dust.DustManager;
import net.kronoz.odyssey.systems.physics.dust.LightDustPinger;
import net.kronoz.odyssey.systems.physics.jetpack.JetpackSystem;
import net.kronoz.odyssey.systems.physics.wire.WireBridge;
import net.kronoz.odyssey.systems.physics.wire.WireClientMirror;
import net.kronoz.odyssey.systems.physics.wire.WireWorldRenderer;
import net.kronoz.odyssey.systems.shaders.FogUniforms;
import net.minecraft.class_1007;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5616;
import net.minecraft.class_591;
import net.minecraft.class_746;
import net.minecraft.class_897;
import java.nio.charset.StandardCharsets;
import java.util.UUID;


public class OdysseyClient implements ClientModInitializer {

    private static WallRunLoopSound current;
    private static final class_2960 FOG = class_2960.method_60655(Odyssey.MODID, "fog");
    private static final class_2960 BLOOM = class_2960.method_60655(Odyssey.MODID, "bloom");
    private boolean fogadded = false;

    @Override
    public void onInitializeClient() {
        ShakeEvents.registerClient();
        ClientElevatorAssist.init();
        WireWorldRenderer.init();
        WireClientMirror.init();
        ModKeybinds.init();
        ApostasyThemeClient.init(ModSounds.APOSTASY_THEME);
        FogUniforms.init();
        SimpleBlockLightManager.initClient();
        SentinelLightClient.initClient();
        ModEntityRenderers.register();
        DialogueClient.init();
        MidnightConfig.init("odyssey", OdysseyConfig.class);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (net.kronoz.odyssey.client.cs.CutsceneRecorder.I.isPreviewActive()) {
                net.kronoz.odyssey.client.cs.CutsceneRecorder.I.tickPreview();
            }
        });
        JetpackSystem.INSTANCE.install(ModItems.JETPACK);
        net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents.END_CLIENT_TICK.register(mc ->
                net.kronoz.odyssey.systems.physics.jetpack.JetpackExhaustManager.tick(mc));
        net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents.AFTER_ENTITIES.register(ctx -> {
            class_4587 ms = ctx.matrixStack();
            class_4597 vcp = ctx.consumers();
            float td = class_310.method_1551().method_60646().method_60637(false);
            ms.method_22903();
            net.kronoz.odyssey.systems.physics.jetpack.JetpackExhaustManager.renderAll(ms, vcp, td);
            ms.method_22909();
        });
        EntityRendererRegistry.register(ModEntities.GROUND_DECAL, GroundDecalRenderer::new);

        DeathUICutscene.register();
        VeilLightCompat.initClient();
        WireBridge.initRenderer();


        DustManager.INSTANCE.installHooks();
        new LightDustPinger().install();
        EntityRendererRegistry.register(ModEntities.LASER_PROJECTILE, ctx -> new class_897<LaserProjectileEntity>(ctx) {
            @Override
            public void render(LaserProjectileEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertices, int light) {}
            @Override
            public class_2960 getTexture(LaserProjectileEntity entity) { return null; }
        });
        EntityRendererRegistry.register(ModEntities.APOSTASY, ApostasyRenderer::new);
        EntityRendererRegistry.register(ModEntities.SENTRY, SentryRenderer::new);
        EntityRendererRegistry.register(ModEntities.SENTINEL, SentinelRenderer::new);
        EntityRendererRegistry.register(ModEntities.LASER_PROJECTILE, LaserProjectileRenderer::new);
        EntityRendererRegistry.register(ModEntities.DEBRIS_BLOCK, DebrisBlockRenderer::new);
        EntityRendererRegistry.register(ModEntities.SHOCKWAVE, ShockwaveRenderer::new);
        class_5616.method_32144(ModBlocks.MAP_BLOCK_ENTITY, MapBlockEntityRenderer::new);
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.MAP_BLOCK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ALARM, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.LIGHT1, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.SHELF1, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.STASISPOD, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.TERMINAL, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.RAILING, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.LIGHT2, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.FACILITY_REBAR_BLOCK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.ENERGY_BARRIER, class_1921.method_23581());
        class_5616.method_32144(ModBlockEntities.STASISPOD, StasisPodBERenderer::new);
        class_5616.method_32144(ModBlockEntities.SHELF1, Shelf1GeoBERenderer::new);
        EntityRendererRegistry.register(ModEntities.ARCANGEL, ArcangelRenderer::new);
        EntityRendererRegistry.register(ModEntities.THRASHER, ThrasherRenderer::new);
        EntityRendererRegistry.register(ModEntities.LOVE, LoveRenderer::new);

        PayloadTypeRegistry.playS2C().register(BossHudUpdatePayload.ID, BossHudUpdatePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(BossHudClearPayload.ID,  BossHudClearPayload.CODEC);

        ClientPlayNetworking.registerGlobalReceiver(BossHudUpdatePayload.ID, (payload, ctx) -> {
            var c = ctx.client();
            c.execute(() -> BossHudClient.put(payload.entityId(), payload.title(), payload.hp(), payload.maxHp()));
        });
        ClientPlayNetworking.registerGlobalReceiver(BossHudClearPayload.ID, (payload, ctx) -> {
            var c = ctx.client();
            c.execute(BossHudClient::clear);
        });
        BossHudClient.register();


        ParticleFactoryRegistry.getInstance().register(ModParticles.SENTRY_SHIELD_FULL_PARTICLE, SentryShieldFullParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(ModParticles.SLICE_PARTICLE, SliceParticle.Factory::new);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            var ppm = VeilRenderSystem.renderer().getPostProcessingManager();
            ppm.add(1, BLOOM);
            fogadded = false;




        });
        BootstrapScenes.registerAll();
        CineNetworking.registerClient();
        ClientTickEvents.END_CLIENT_TICK.register(client -> CutsceneManager.I.clientTick());


        ClientTickEvents.END_CLIENT_TICK.register(client -> {


            if (client.field_1724 == null || client.field_1687 == null) return;

            var ppm = VeilRenderSystem.renderer().getPostProcessingManager();

            boolean inVoid = client.field_1687.method_27983().method_29177().equals(class_2960.method_60654("odyssey:void"));
            if (inVoid && !fogadded) {
                ppm.add(2,FOG);
                fogadded = true;
            } else if (!inVoid && fogadded) {
                ppm.remove(FOG);
                fogadded = false;
            }
        });



        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((type, renderer, helper, ctx) -> {
            if (type == class_1299.field_6097 && renderer instanceof class_1007 per) {
                class_3883<class_1657, class_591<class_1657>> castCtx =
                        (class_3883<class_1657, class_591<class_1657>>) (class_3883<?, ?>) per;


            }
        });
    }
    public static void update(class_746 p, WallRun.WallState s) {
        boolean active = s != null && s.active();
        var sm = class_310.method_1551().method_1483();

        if (active) {
            if (current == null || current.method_4793()) {
                current = new WallRunLoopSound(p);
                sm.method_4873(current);
            }
        } else if (current != null) {
            sm.method_4870(current);
            current = null;
        }
    }
    private static UUID nameId(String s) {
        return UUID.nameUUIDFromBytes(s.getBytes(StandardCharsets.UTF_8));
    }
}