package net.kronoz.odyssey.block;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_3218;

public final class SequencerRegistry {
    @FunctionalInterface
    public interface SequencerAction {
        void run(class_3218 world, class_2338 pos);
    }

    private static final Map<String, SequencerAction> ACTIONS = new ConcurrentHashMap<>();

    private SequencerRegistry() {}

    public static void register(String key, SequencerAction action) {
        ACTIONS.put(key, action);
    }

    public static boolean fire(String key, class_3218 world, class_2338 pos) {
        SequencerAction a = ACTIONS.get(key);
        if (a == null) return false;
        a.run(world, pos);
        return true;
    }

    public static void bootstrapDefaults() {
        register("beep", (w, p) -> {
            w.method_8396(null, p, net.minecraft.class_3417.field_14793.comp_349(),
                    net.minecraft.class_3419.field_15245, 1.0f, 1.0f);
        });
        register("flash", (w, p) -> w.method_20290(2001, p, net.minecraft.class_2248.method_9507(w.method_8320(p))));
        register("particles", (w, p) -> w.method_14199(class_2398.field_11207,
                p.method_10263() + 0.5, p.method_10264() + 1.0, p.method_10260() + 0.5, 12, 0.25, 0.25, 0.25, 0.0));
    }

    // alias for your Odyssey.init() call
    public static void init() {
        bootstrapDefaults();
    }
}
