package net.kronoz.odyssey.block.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Environment(EnvType.CLIENT)
public final class DecalLightClient {
    private static final Map<Integer, LightRenderHandle<PointLightData>> HANDLES = new HashMap<>();
    private static final Map<Integer, PointLightData> DATA = new HashMap<>();
    private static class_2960 lastWorldId = null;

    public static void initClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> clearAll());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> clearAll());

        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> pruneNow()); // safety on region unloads

        WorldRenderEvents.START.register(ctx -> {
            if (!RenderSystem.isOnRenderThread()) return;
            class_310 mc = class_310.method_1551();
            class_638 w = mc.field_1687;

            if (w == null) { clearAll(); return; }

            class_2960 wid = w.method_27983().method_29177();
            if (lastWorldId == null || !lastWorldId.equals(wid)) {
                clearAll();
                lastWorldId = wid;
            }

            if (mc.field_1724 == null || !mc.field_1724.method_5805()) {
                clearAll();
                return;
            }

            pruneNow();
        });
    }

    public static void update(int id, double x, double y, double z,
                              float r, float g, float b,
                              float brightness, float radius) {
        if (!RenderSystem.isOnRenderThread()) return;
        if (brightness <= 0f || radius <= 0f) { remove(id); return; }

        var renderer = (VeilRenderSystem.renderer() != null) ? VeilRenderSystem.renderer().getLightRenderer() : null;
        if (renderer == null) return;

        PointLightData pl = DATA.get(id);
        LightRenderHandle<PointLightData> handle = HANDLES.get(id);

        if (pl == null || handle == null || !handle.isValid()) {
            pl = new PointLightData()
                    .setBrightness(brightness)
                    .setColor(r, g, b)
                    .setRadius(radius);
            pl.setPosition((float) x, (float) y, (float) z);
            handle = renderer.addLight(pl);
            DATA.put(id, pl);
            HANDLES.put(id, handle);
            return;
        }

        pl.setBrightness(brightness);
        pl.setColor(r, g, b);
        pl.setRadius(radius);
        pl.setPosition((float) x, (float) y, (float) z);
        handle.markDirty();
    }

    public static void remove(int id) {
        LightRenderHandle<PointLightData> h = HANDLES.remove(id);
        if (h != null && h.isValid()) h.close();
        DATA.remove(id);
    }

    private static void clearAll() {
        for (LightRenderHandle<PointLightData> h : HANDLES.values()) {
            if (h != null && h.isValid()) h.close();
        }
        HANDLES.clear();
        DATA.clear();
    }

    private static void pruneNow() {
        class_310 mc = class_310.method_1551();
        class_638 w = mc.field_1687;
        if (w == null) { clearAll(); return; }

        Iterator<Map.Entry<Integer, LightRenderHandle<PointLightData>>> it = HANDLES.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, LightRenderHandle<PointLightData>> e = it.next();
            int id = e.getKey();
            LightRenderHandle<PointLightData> h = e.getValue();

            class_1297 ent = w.method_8469(id);
            boolean dead = (ent == null) || ent.method_31481();

            if (dead || h == null || !h.isValid()) {
                if (h != null && h.isValid()) h.close();
                it.remove();
                DATA.remove(id);
            }
        }
    }

    private DecalLightClient() {}
}
