package net.kronoz.odyssey.block.custom;

import net.kronoz.odyssey.entity.apostasy.ApostasyEntity;
import net.kronoz.odyssey.entity.arcangel.ArcangelEntity;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import java.util.Comparator;

public class DevinityMachineBlock extends class_2248 {

    public static final class_2753 FACING = class_2741.field_12481;
    private static final int SPAWN_DELAY = 1; // tick delay to ensure world is loaded

    public DevinityMachineBlock(class_2251 settings) {
        super(settings.method_22488());
        method_9590(method_9595().method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!world.field_9236) {
            world.method_39279(pos, this, SPAWN_DELAY);
        }
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state,
                         net.minecraft.class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (!world.field_9236) {
            method_9588(state, (class_3218) world, pos, null);
        }
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, net.minecraft.class_5819 random) {

    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;
        if (!(player instanceof class_3222 sp)) return class_1269.field_5812;
        if (sp.method_7337() || sp.method_7325()) return class_1269.field_5812;

        sp.method_5643((world).method_48963().method_48831(), 8f);

        class_238 box = new class_238(pos).method_1014(64);
        ArcangelEntity nearest = world.method_8390(ArcangelEntity.class, box, e -> true)
                .stream()
                .min(Comparator.comparingDouble(
                        e -> e.method_5649(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5)
                ))
                .orElse(null);

        if (nearest != null) {
            nearest.addBlood(25);
            world.method_8396(null, pos, class_3417.field_23116, class_3419.field_15245, 1f, 0.8f);
        }

        return class_1269.field_5812;
    }
}
