package net.kronoz.odyssey.block.custom;

import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.block.CollisionShapeHelper;
import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public class LightBlock extends class_2248 implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    private static final Map<class_2350, class_265> DIR_SHAPES =
            CollisionShapeHelper.loadDirectionalCollisionFromModelJson(Odyssey.MODID, "light_1");

    public LightBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9595().method_11664()
                .method_11657(FACING, class_2350.field_11036)
                .method_11657(WATERLOGGED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, WATERLOGGED);
    }

    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        boolean water = ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910;
        return method_9564().method_11657(FACING, ctx.method_8038()).method_11657(WATERLOGGED, water);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighborState,
                                                class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (state.method_11654(WATERLOGGED)) {
            world.method_39281(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, dir, neighborState, world, pos, neighborPos);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moved) {
        super.method_9615(state, world, pos, oldState, moved);
        if (world.field_9236) SimpleBlockLightManager.requestAdd(pos);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state,
                         net.minecraft.class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (world.field_9236) SimpleBlockLightManager.requestAdd(pos);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (world.field_9236 && (!newState.method_27852(this))) {
            SimpleBlockLightManager.requestRemove(pos);
        }
    }

    @Override
    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state,
                           @Nullable net.minecraft.class_2586 blockEntity, class_1799 tool) {
        super.method_9585(world, pos, state);
        if (world.field_9236) SimpleBlockLightManager.requestRemove(pos);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654(FACING));
        return s != null ? s : class_259.method_1077();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654(FACING));
        return s != null ? s : class_259.method_1077();
    }

    @Override
    public class_2464 method_9604(class_2680 state) { return class_2464.field_11458; }
}
