package net.kronoz.odyssey.block.custom;

import com.mojang.serialization.MapCodec;
import net.kronoz.odyssey.block.CollisionShapeHelper;
import net.kronoz.odyssey.entity.Shelf1BlockEntity;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class Shelf1Block extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;

    private static final String NS = "odyssey";
    private static final String MODEL_PATH = "shelf1";

    public Shelf1Block(class_2251 settings) {
        super(settings.method_22488());
        method_9590(method_9595().method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> b) { b.method_11667(FACING); }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return CollisionShapeHelper.getDirectionalShape(NS, MODEL_PATH, state.method_11654(FACING));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return CollisionShapeHelper.getDirectionalShape(NS, MODEL_PATH, state.method_11654(FACING));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return CollisionShapeHelper.getDirectionalShape(NS, MODEL_PATH, state.method_11654(FACING));
    }

    @Override public class_2464 method_9604(class_2680 state) { return class_2464.field_11458; }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) { return new Shelf1BlockEntity(pos, state); }

    @Override public boolean method_9498(class_2680 state) { return true; }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof Shelf1BlockEntity shelf) {
            int filled = shelf.getFilledSlots(), total = shelf.size();
            return total == 0 ? 0 : Math.round(15f * (filled / (float) total));
        }
        return 0;
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof Shelf1BlockEntity shelf)) return class_1269.field_5811;

        boolean bothHandsEmpty = player.method_6047().method_7960() && player.method_6079().method_7960();
        if (!bothHandsEmpty) return class_1269.field_5811;

        if (world.field_9236) {
            clientPreviewTake(world, pos);
            return class_1269.field_5812;
        }

        int slot = shelf.lastFilledSlot();
        if (slot >= 0) {
            class_1799 s = shelf.getStack(slot);
            if (!player.method_31548().method_7394(s.method_7972())) player.method_7328(s.method_7972(), false);
            shelf.clearSlot(slot);
            world.method_8455(pos, this);
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }
    private static void clientPreviewTake(class_1937 world, class_2338 pos) {
        if (!(world instanceof net.minecraft.class_638)) return;
        var be = world.method_8321(pos);
        if (!(be instanceof net.kronoz.odyssey.entity.Shelf1BlockEntity shelf)) return;

        int slot = shelf.lastFilledSlot();
        if (slot >= 0) {
            shelf.clearSlot(slot);
        }
    }

    private static void clientPreviewPlace(class_1937 world, class_2338 pos, class_1799 stack, boolean placeAll) {
        if (!(world instanceof net.minecraft.class_638)) return;
        if (stack.method_7960()) return;
        var be = world.method_8321(pos);
        if (!(be instanceof net.kronoz.odyssey.entity.Shelf1BlockEntity shelf)) return;

        int slot = shelf.firstEmptySlot();
        if (slot >= 0) {
            int count = placeAll ? stack.method_7947() : 1;
            shelf.setStack(slot, stack.method_46651(count));
        }
    }
    @Override
    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos,
                                          class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof Shelf1BlockEntity shelf)) return class_9062.field_47731;
        if (stack.method_7960()) return class_9062.field_47731;

        if (world.field_9236) {
            clientPreviewPlace(world, pos, stack, player.method_5715());
            return class_9062.field_47728;
        }

        int slot = shelf.firstEmptySlot();
        if (slot >= 0) {
            int count = player.method_5715() ? stack.method_7947() : 1;
            class_1799 placed = stack.method_46651(count);
            shelf.setStack(slot, placed);
            stack.method_7934(count);
            world.method_8455(pos, this);
            return class_9062.field_47729;
        }
        return class_9062.field_47728;
    }
}
