package net.kronoz.odyssey.block.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.joml.Quaternionf;

import java.util.*;

public final class SimpleBlockLightManager {
    private SimpleBlockLightManager() {}

    private static final float AL_BRIGHTNESS = 1.0f;
    private static final float AL_ANGLE = (float) Math.toRadians(40.0);
    private static final float AL_DISTANCE = 25.0f;
    private static final double AL_SIZE_X = 0.20;
    private static final double AL_SIZE_Y = 0.20;

    private static final float PL_BRIGHTNESS = 3.0f;
    private static final float PL_RADIUS = 3.0f;

    private static final float CLR_R = 1f, CLR_G = 0.796f, CLR_B = 0.494f;

    private static final Quaternionf ORIENTATION = new Quaternionf().rotateX((float)(-Math.PI/2.0));

    // ---- State ----
    private static final Map<class_2338, LightRenderHandle<AreaLightData>> AREA_HANDLES = new HashMap<>();
    private static final Map<class_2338, AreaLightData> AREA_DATA = new HashMap<>();

    private static final Map<class_2338, LightRenderHandle<PointLightData>> POINT_HANDLES = new HashMap<>();
    private static final Map<class_2338, PointLightData> POINT_DATA = new HashMap<>();

    private static final Set<class_2338> PENDING_ADD = new HashSet<>();
    private static final Set<class_2338> PENDING_REMOVE = new HashSet<>();
    private static boolean initialScanPending = true;

    private static boolean matches(class_2680 st) {
        return st.method_26204() instanceof net.kronoz.odyssey.block.custom.LightBlock;
    }

    public static void initClient() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> resetForNewWorld());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> resetForNewWorld());

        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world == null || chunk == null) return;
            scanChunkForLights(world, chunk.method_12004());
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (world == null || chunk == null) return;
            removeLightsInChunk(chunk.method_12004());
        });

        WorldRenderEvents.START.register(ctx -> {
            if (!RenderSystem.isOnRenderThread()) return;
            class_310 mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null) return;

            if (initialScanPending) {
                doInitialScan(mc.field_1687);
                initialScanPending = false;
            }

            if (!PENDING_REMOVE.isEmpty()) {
                for (class_2338 pos : PENDING_REMOVE) removeNow(pos);
                PENDING_REMOVE.clear();
            }
            if (!PENDING_ADD.isEmpty()) {
                for (class_2338 pos : PENDING_ADD) {
                    class_2680 st = mc.field_1687.method_8320(pos);
                    if (!st.method_26215() && matches(st)) addNow(pos);
                }
                PENDING_ADD.clear();
            }

            Iterator<Map.Entry<class_2338, LightRenderHandle<AreaLightData>>> it = AREA_HANDLES.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<class_2338, LightRenderHandle<AreaLightData>> e = it.next();
                class_2338 pos = e.getKey();
                class_2680 st = mc.field_1687.method_8320(pos);
                if (st.method_26215() || !matches(st)) {
                    LightRenderHandle<AreaLightData> ah = e.getValue();
                    if (ah != null && ah.isValid()) ah.close();
                    AREA_DATA.remove(pos);
                    LightRenderHandle<PointLightData> ph = POINT_HANDLES.remove(pos);
                    if (ph != null && ph.isValid()) ph.close();
                    POINT_DATA.remove(pos);
                    it.remove();
                }
            }
        });

        WorldRenderEvents.BEFORE_ENTITIES.register(ctx -> {
            class_310 mc = class_310.method_1551();
            if (mc == null) return;

            for (class_2338 pos : AREA_DATA.keySet()) {
                class_243 c = blockCenter(pos);

                AreaLightData al = AREA_DATA.get(pos);
                if (al != null) {
                    al.getPosition().set(c.field_1352, c.field_1351, c.field_1350);
                    al.getOrientation().set(ORIENTATION);
                    LightRenderHandle<AreaLightData> ah = AREA_HANDLES.get(pos);
                    if (ah != null && ah.isValid()) ah.markDirty();
                }

                PointLightData pl = POINT_DATA.get(pos);
                if (pl != null) {
                    pl.setPosition((float)c.field_1352, (float)c.field_1351, (float)c.field_1350);
                    LightRenderHandle<PointLightData> ph = POINT_HANDLES.get(pos);
                    if (ph != null && ph.isValid()) ph.markDirty();
                }
            }
        });
    }

    public static void requestAdd(class_2338 pos) {
        PENDING_REMOVE.remove(pos);
        PENDING_ADD.add(pos);
    }
    public static void requestRemove(class_2338 pos) {
        PENDING_ADD.remove(pos);
        PENDING_REMOVE.add(pos);
    }

    private static void resetForNewWorld() {
        for (LightRenderHandle<AreaLightData> h : AREA_HANDLES.values()) {
            if (h != null && h.isValid()) h.close();
        }
        AREA_HANDLES.clear();
        AREA_DATA.clear();

        for (LightRenderHandle<PointLightData> h : POINT_HANDLES.values()) {
            if (h != null && h.isValid()) h.close();
        }
        POINT_HANDLES.clear();
        POINT_DATA.clear();

        PENDING_ADD.clear();
        PENDING_REMOVE.clear();
        initialScanPending = true;
    }

    private static void doInitialScan(class_638 world) {
        if (world == null) return;
        class_310 mc = class_310.method_1551();
        class_2338 p = (mc != null && mc.field_1724 != null) ? mc.field_1724.method_24515() : class_2338.field_10980;
        int r = 4;
        int pcx = p.method_10263() >> 4, pcz = p.method_10260() >> 4;
        for (int cx = pcx - r; cx <= pcx + r; cx++) {
            for (int cz = pcz - r; cz <= pcz + r; cz++) {
                if (world.method_2935().method_12246(cx, cz) != null) {
                    scanChunkForLights(world, new class_1923(cx, cz));
                }
            }
        }
    }

    private static void scanChunkForLights(class_638 world, class_1923 cpos) {
        int minY = world.method_31607();
        int maxY = world.method_31600();
        int startX = cpos.method_8326();
        int startZ = cpos.method_8328();

        for (int y = minY; y < maxY; y++) {
            for (int x = 0; x < 16; x++) {
                for (int z = 0; z < 16; z++) {
                    class_2338 pos = new class_2338(startX + x, y, startZ + z);
                    class_2680 st = world.method_8320(pos);
                    if (!st.method_26215() && matches(st)) {
                        requestAdd(pos);
                    }
                }
            }
        }
    }

    private static void removeLightsInChunk(class_1923 cpos) {
        List<class_2338> toRemove = new ArrayList<>();
        for (class_2338 pos : AREA_HANDLES.keySet()) {
            if ((pos.method_10263() >> 4) == cpos.field_9181 && (pos.method_10260() >> 4) == cpos.field_9180) {
                toRemove.add(pos);
            }
        }
        for (class_2338 pos : toRemove) requestRemove(pos);
    }

    private static void addNow(class_2338 pos) {
        if (AREA_HANDLES.containsKey(pos)) return;

        AreaLightData al = new AreaLightData()
                .setBrightness(AL_BRIGHTNESS)
                .setColor(CLR_R, CLR_G, CLR_B)
                .setSize(AL_SIZE_X, AL_SIZE_Y)
                .setAngle(AL_ANGLE)
                .setDistance(AL_DISTANCE);

        class_243 c = blockCenter(pos);
        al.getPosition().set(c.field_1352, c.field_1351, c.field_1350);
        al.getOrientation().set(ORIENTATION);

        PointLightData pl = new PointLightData()
                .setBrightness(PL_BRIGHTNESS)
                .setColor(CLR_R, CLR_G, CLR_B)
                .setRadius(PL_RADIUS);
        pl.setPosition((float)c.field_1352, (float)c.field_1351, (float)c.field_1350);

        if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) {
            PENDING_ADD.add(pos);
            return;
        }

        LightRenderHandle<AreaLightData> ah =
                VeilRenderSystem.renderer().getLightRenderer().addLight(al);
        LightRenderHandle<PointLightData> ph =
                VeilRenderSystem.renderer().getLightRenderer().addLight(pl);

        AREA_DATA.put(pos, al);
        AREA_HANDLES.put(pos, ah);
        POINT_DATA.put(pos, pl);
        POINT_HANDLES.put(pos, ph);
    }

    private static void removeNow(class_2338 pos) {
        LightRenderHandle<AreaLightData> ah = AREA_HANDLES.remove(pos);
        if (ah != null && ah.isValid()) ah.close();
        AREA_DATA.remove(pos);

        LightRenderHandle<PointLightData> ph = POINT_HANDLES.remove(pos);
        if (ph != null && ph.isValid()) ph.close();
        POINT_DATA.remove(pos);
    }

    private static class_243 blockCenter(class_2338 pos) {
        return new class_243(pos.method_10263() + 0.5, pos.method_10264() + 0.8, pos.method_10260() + 0.5);
    }
}
