package net.kronoz.odyssey.block.custom;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.block.CollisionShapeHelper;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpedLigtBlock extends class_2248 {
    public static final class_2753 FACING = class_2741.field_12525;

    private static final Map<class_2350, class_265> DIR_SHAPES =
            CollisionShapeHelper.loadDirectionalCollisionFromModelJson(Odyssey.MODID, "static_beacon");

    private static final float  AL_BRIGHTNESS = 4.0f;
    private static final float  AL_DISTANCE   = 96.0f;
    private static final float  AL_ANGLE      = (float) Math.toRadians(35.0);
    private static final double AL_SIZE_X     = 0.1;
    private static final double AL_SIZE_Y     = 0.1;

    private static final float  PL_BRIGHTNESS = 2.0f;
    private static final float  PL_RADIUS     = 3.0f;

    private static final float CLR_R = 1f, CLR_G = 1f, CLR_B = 1f;

    private static final Quaternionf ORIENTATION_DOWN = new Quaternionf().rotateX((float)(-Math.PI/2.0));

    private static final Map<class_2338, LightRenderHandle<AreaLightData>>  AREA_HANDLES = new HashMap<>();
    private static final Map<class_2338, LightRenderHandle<PointLightData>> POINT_HANDLES = new HashMap<>();
    private static final Map<class_2338, AreaLightData>  AREA_DATA  = new HashMap<>();
    private static final Map<class_2338, PointLightData> POINT_DATA = new HashMap<>();

    private static final class_243 LIGHT_OFFSET = new class_243(0.5, 0.8, 0.5);

    private static boolean hooks = false;
    private static boolean rescanPending = false;
    private static boolean rendererWasReady = false;

    public SpedLigtBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9595().method_11664().method_11657(FACING, class_2350.field_11043));
        ensureHooks();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(FACING, ctx.method_8038());
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moved) {
        super.method_9615(state, world, pos, oldState, moved);
        if (world.field_9236) spawnLightsIfNeeded(world, pos);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state,
                         net.minecraft.class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (world.field_9236) spawnLightsIfNeeded(world, pos);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (world.field_9236 && !newState.method_27852(this)) removeLightsIfAny(pos);
    }

    @Override
    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        super.method_9585(world, pos, state);
        if (world.method_8608()) removeLightsIfAny(pos);
    }

    @Override
    public class_2680 method_9598(class_2680 state, net.minecraft.class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, net.minecraft.class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654(FACING));
        return (s == null || s.method_1110()) ? class_259.method_1077() : s;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654(FACING));
        return (s == null || s.method_1110()) ? class_259.method_1077() : s;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    private static void spawnLightsIfNeeded(class_1937 world, class_2338 pos) {
        if (!world.field_9236) return;
        if (AREA_HANDLES.containsKey(pos) || POINT_HANDLES.containsKey(pos)) return;
        if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) return;

        class_243 c = new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260()).method_1019(LIGHT_OFFSET);

        AreaLightData al = new AreaLightData()
                .setBrightness(AL_BRIGHTNESS)
                .setColor(CLR_R, CLR_G, CLR_B)
                .setSize(AL_SIZE_X, AL_SIZE_Y)
                .setAngle(AL_ANGLE)
                .setDistance(AL_DISTANCE);
        al.getPosition().set(c.field_1352, c.field_1351, c.field_1350);
        al.getOrientation().set(ORIENTATION_DOWN);

        PointLightData pl = new PointLightData()
                .setBrightness(PL_BRIGHTNESS)
                .setColor(CLR_R, CLR_G, CLR_B)
                .setRadius(PL_RADIUS);
        pl.setPosition((float) c.field_1352, (float) c.field_1351, (float) c.field_1350);

        LightRenderHandle<AreaLightData> ah =
                VeilRenderSystem.renderer().getLightRenderer().addLight(al);
        LightRenderHandle<PointLightData> ph =
                VeilRenderSystem.renderer().getLightRenderer().addLight(pl);

        AREA_HANDLES.put(pos, ah);
        POINT_HANDLES.put(pos, ph);
        AREA_DATA.put(pos, al);
        POINT_DATA.put(pos, pl);
    }

    private static void removeLightsIfAny(class_2338 pos) {
        LightRenderHandle<AreaLightData> ah = AREA_HANDLES.remove(pos);
        if (ah != null && ah.isValid()) ah.close();
        AREA_DATA.remove(pos);

        LightRenderHandle<PointLightData> ph = POINT_HANDLES.remove(pos);
        if (ph != null && ph.isValid()) ph.close();
        POINT_DATA.remove(pos);
    }

    private static void ensureHooks() {
        if (hooks) return;
        hooks = true;

        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            rescanPending = true;
            rendererWasReady = false;
        });

        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            for (LightRenderHandle<AreaLightData> h : AREA_HANDLES.values()) if (h != null && h.isValid()) h.close();
            for (LightRenderHandle<PointLightData> h : POINT_HANDLES.values()) if (h != null && h.isValid()) h.close();
            AREA_HANDLES.clear();
            POINT_HANDLES.clear();
            AREA_DATA.clear();
            POINT_DATA.clear();
            rescanPending = false;
            rendererWasReady = false;
        });

        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world == null || chunk == null) return;
            if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) return;
            class_1923 cpos = chunk.method_12004();
            int minY = world.method_31607();
            int maxY = world.method_31600();
            int sx = cpos.method_8326();
            int sz = cpos.method_8328();
            for (int y = minY; y < maxY; y++) {
                for (int x = 0; x < 16; x++) {
                    for (int z = 0; z < 16; z++) {
                        class_2338 bp = new class_2338(sx + x, y, sz + z);
                        class_2680 st = world.method_8320(bp);
                        if (st.method_26204() instanceof SpedLigtBlock) spawnLightsIfNeeded(world, bp);
                    }
                }
            }
        });

        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (world == null || chunk == null) return;
            class_1923 cpos = chunk.method_12004();
            List<class_2338> toRemove = new ArrayList<>();
            for (class_2338 p : AREA_HANDLES.keySet()) {
                if ((p.method_10263() >> 4) == cpos.field_9181 && (p.method_10260() >> 4) == cpos.field_9180) toRemove.add(p);
            }
            for (class_2338 p : toRemove) removeLightsIfAny(p);
        });

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client == null || client.method_1493()) return;

            boolean rendererReady = VeilRenderSystem.renderer() != null
                    && VeilRenderSystem.renderer().getLightRenderer() != null;

            if (rendererReady && !rendererWasReady) rescanPending = true;
            rendererWasReady = rendererReady;

            if (rescanPending && client.field_1687 != null && client.field_1724 != null && rendererReady) {
                var w = client.field_1687;
                var p = client.field_1724.method_24515();
                int r = 4;
                for (int cx = (p.method_10263() >> 4) - r; cx <= (p.method_10263() >> 4) + r; cx++) {
                    for (int cz = (p.method_10260() >> 4) - r; cz <= (p.method_10260() >> 4) + r; cz++) {
                        if (w.method_2935().method_12246(cx, cz) == null) continue;
                        class_1923 cpos = new class_1923(cx, cz);
                        int minY = w.method_31607();
                        int maxY = w.method_31600();
                        int sx = cpos.method_8326();
                        int sz = cpos.method_8328();
                        for (int y = minY; y < maxY; y++) {
                            for (int x = 0; x < 16; x++) {
                                for (int z = 0; z < 16; z++) {
                                    class_2338 bp = new class_2338(sx + x, y, sz + z);
                                    class_2680 st = w.method_8320(bp);
                                    if (st.method_26204() instanceof SpedLigtBlock) spawnLightsIfNeeded(w, bp);
                                }
                            }
                        }
                    }
                }
                rescanPending = false;
            }
        });
    }
}
