package net.kronoz.odyssey.block.custom;

import com.mojang.serialization.MapCodec;
import net.kronoz.odyssey.block.GeoCollisionHelper;
import net.kronoz.odyssey.entity.StasisPodBlockEntity;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class StasisPodBlock extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2758 PART = class_2758.method_11867("part", 0, 44);
    private static final class_2338[] OFFSETS = buildOffsets();

    public StasisPodBlock(class_2251 settings) {
        super(settings.method_22488().method_9632(3.0f));
        method_9590(method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(PART, 4));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Override protected void method_9515(class_2689.class_2690<class_2248, class_2680> b) { b.method_11667(FACING, PART); }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8042().method_10153();
        class_2338 origin = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        if (!canPlaceStructure(world, origin, facing, ctx)) return null;
        placeStructure(world, origin, facing);
        return method_9564().method_11657(FACING, facing).method_11657(PART, 4);
    }

    @Override public class_2464 method_9604(class_2680 s) { return class_2464.field_11458; }
    @Override public class_1269 method_55766(class_2680 s, class_1937 w, class_2338 p, class_1657 pl, class_3965 hit) { return class_1269.field_5811; }

    @Nullable @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return state.method_11654(PART) == 4 ? new StasisPodBlockEntity(pos, state) : null;
    }

    @Override
    public class_265 method_9549(class_2680 s, class_1922 w, class_2338 p, class_3726 c) {
        return GeoCollisionHelper
                .partShape("odyssey", "block/stasispod", s.method_11654(PART), s.method_11654(FACING));
    }
    @Override
    public class_265 method_9530(class_2680 s, class_1922 w, class_2338 p, class_3726 c) {
        return GeoCollisionHelper
                .partShape("odyssey", "block/stasispod", s.method_11654(PART), s.method_11654(FACING));
    }
    @Override
    public class_265 method_9584(class_2680 s, class_1922 w, class_2338 p) {
        return GeoCollisionHelper
                .partShape("odyssey", "block/stasispod", s.method_11654(PART), s.method_11654(FACING));
    }



    private static class_2338 rotateRel(class_2338 rel, class_2350 facing) {
        return switch (facing) {
            case field_11043 -> rel;
            case field_11035 -> new class_2338(-rel.method_10263(), rel.method_10264(), -rel.method_10260());
            case field_11039  -> new class_2338(rel.method_10260(), rel.method_10264(), -rel.method_10263());
            case field_11034  -> new class_2338(-rel.method_10260(), rel.method_10264(), rel.method_10263());
            default    -> rel;
        };
    }

    private boolean canPlaceStructure(class_1937 world, class_2338 origin, class_2350 facing, class_1750 ctx) {
        for (class_2338 o : OFFSETS) {
            class_2338 p = origin.method_10081(rotateRel(o, facing));
            class_2680 st = world.method_8320(p);
            if (!st.method_26215() && !st.method_26166(ctx)) return false;
        }
        return true;
    }

    private void placeStructure(class_1937 world, class_2338 origin, class_2350 facing) {
        for (int i = 0; i < OFFSETS.length; i++) {
            class_2338 p = origin.method_10081(rotateRel(OFFSETS[i], facing));
            world.method_8652(p, method_9564().method_11657(FACING, facing).method_11657(PART, i), class_2248.field_31036 | class_2248.field_31031);
        }
    }

    @Override
    public void method_9536(class_2680 s, class_1937 w, class_2338 pos, class_2680 ns, boolean moved) {
        if (s.method_27852(ns.method_26204())) return;
        class_2350 face = s.method_11654(FACING);
        int part = s.method_11654(PART);
        class_2338 origin = pos.method_10059(rotateRel(OFFSETS[part], face));
        for (class_2338 o : OFFSETS) {
            class_2338 p = origin.method_10081(rotateRel(o, face));
            if (w.method_8320(p).method_27852(this)) w.method_8650(p, false);
        }
    }

    private static class_2338[] buildOffsets() {
        class_2338[] list = new class_2338[45];
        int i = 0;
        for (int y = 0; y < 5; y++) for (int z = -1; z <= 1; z++) for (int x = -1; x <= 1; x++) list[i++] = new class_2338(x, y, z);
        return list;
    }
}
