package net.kronoz.odyssey.block.custom;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.block.CollisionShapeHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TerminalBlock extends class_2248 {
    public static final class_2753 FACING = class_2741.field_12481;

    private static final Map<class_2350, class_265> DIR_SHAPES =
            CollisionShapeHelper.loadDirectionalCollisionFromModelJson(Odyssey.MODID, "terminal");

    private static final double AL_SIZE_X = 0.30;
    private static final double AL_SIZE_Y = 0.22;
    private static final float  AL_ANGLE  = (float) Math.toRadians(50.0);
    private static final float  AL_DIST   = 20.0f;
    private static final float  PL_RADIUS = 5.0f;
    private static final float CLR_R = 0.48f, CLR_G = 0.85f, CLR_B = 1.00f;
    private static final float BASE_BRIGHTNESS = 1.0f;

    private static final Quaternionf ORIENT_NORTH = new Quaternionf().rotateY(0f);
    private static final Quaternionf ORIENT_EAST  = new Quaternionf().rotateY((float)Math.toRadians(90));
    private static final Quaternionf ORIENT_SOUTH = new Quaternionf().rotateY((float)Math.toRadians(180));
    private static final Quaternionf ORIENT_WEST  = new Quaternionf().rotateY((float)Math.toRadians(270));

    private static final Map<class_2338, LightRenderHandle<AreaLightData>>  AREA_HANDLES = new ConcurrentHashMap<>();
    private static final Map<class_2338, LightRenderHandle<PointLightData>> POINT_HANDLES = new ConcurrentHashMap<>();
    private static final Map<class_2338, AreaLightData>  AREA_DATA  = new ConcurrentHashMap<>();
    private static final Map<class_2338, PointLightData> POINT_DATA = new ConcurrentHashMap<>();

    private static final float X_CENTER = 0.5f;
    private static final float Y_CENTER = 0.62f;
    private static final float FACE_EPS = 0.001f;

    private static final java.util.Random RNG = new java.util.Random();
    private enum Phase { IDLE, BURST_OFF, BURST_ON, TAIL_WAIT, TAIL_OFF, TAIL_ON, SETTLE }
    private static final class Flicker {
        Phase phase = Phase.IDLE;
        float cooldown;
        int flashesLeft;
        float timer;
        float offDur;
        float onDur;
        int tailLeft;
        float tailGap;
        float settleTime;
        float settleDur;
        float settleFrom;
    }
    private static final Map<class_2338, Flicker> FLICKER = new ConcurrentHashMap<>();

    private static boolean hooks = false;
    private static boolean rescanPending = false;
    private static boolean rendererWasReady = false;

    public TerminalBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9595().method_11664().method_11657(FACING, class_2350.field_11043));
        ensureHooks();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) { builder.method_11667(FACING); }

    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moved) {
        super.method_9615(state, world, pos, oldState, moved);
        if (world.field_9236) spawnLightsIfNeeded(world, pos, state);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (world.field_9236) spawnLightsIfNeeded(world, pos, state);
    }


    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654(FACING));
        return s != null ? s : class_259.method_1077();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 s = DIR_SHAPES.get(state.method_11654(FACING));
        return s != null ? s : class_259.method_1077();
    }

    @Override
    public class_2464 method_9604(class_2680 state) { return class_2464.field_11458; }

    private static void spawnLightsIfNeeded(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) return;
        if (AREA_HANDLES.containsKey(pos) || POINT_HANDLES.containsKey(pos)) return;
        if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) return;

        class_2350 f = state.method_11654(FACING);
        double x = pos.method_10263() + 0.5;
        double y = pos.method_10264() + Y_CENTER;
        double z = pos.method_10260() + 0.5;
        Quaternionf orient;
        switch (f) {
            case field_11043 -> { z = pos.method_10260() + FACE_EPS; orient = ORIENT_NORTH; }
            case field_11035 -> { z = pos.method_10260() + 1 - FACE_EPS; orient = ORIENT_SOUTH; }
            case field_11034  -> { x = pos.method_10263() + 1 - FACE_EPS; orient = ORIENT_EAST; }
            case field_11039  -> { x = pos.method_10263() + FACE_EPS; orient = ORIENT_WEST; }
            default    -> { orient = ORIENT_NORTH; }
        }

        AreaLightData al = new AreaLightData()
                .setBrightness(BASE_BRIGHTNESS)
                .setColor(CLR_R, CLR_G, CLR_B)
                .setSize(AL_SIZE_X, AL_SIZE_Y)
                .setAngle(AL_ANGLE)
                .setDistance(AL_DIST);
        al.getPosition().set(x, y, z);
        al.getOrientation().set(orient);

        PointLightData pl = new PointLightData()
                .setBrightness(BASE_BRIGHTNESS)
                .setColor(CLR_R, CLR_G, CLR_B)
                .setRadius(PL_RADIUS);
        pl.setPosition((float)x, (float)y, (float)z);

        var lr = VeilRenderSystem.renderer().getLightRenderer();
        LightRenderHandle<AreaLightData> ah = lr.addLight(al);
        LightRenderHandle<PointLightData> ph = lr.addLight(pl);

        AREA_HANDLES.put(pos, ah);
        POINT_HANDLES.put(pos, ph);
        AREA_DATA.put(pos, al);
        POINT_DATA.put(pos, pl);

        Flicker fl = new Flicker();
        fl.phase = Phase.IDLE;
        fl.cooldown = rand(5f, 30f);
        FLICKER.put(pos, fl);
    }

    private static void removeLightsIfAny(class_2338 pos) {
        LightRenderHandle<AreaLightData> ah = AREA_HANDLES.remove(pos);
        if (ah != null && ah.isValid()) ah.close();
        AREA_DATA.remove(pos);
        LightRenderHandle<PointLightData> ph = POINT_HANDLES.remove(pos);
        if (ph != null && ph.isValid()) ph.close();
        POINT_DATA.remove(pos);
        FLICKER.remove(pos);
    }
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        super.method_9576(world, pos, state, player);
        if (world.field_9236) removeLightsIfAny(pos);
        return state;
    }

    @Override
    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state,
                           @Nullable net.minecraft.class_2586 be, class_1799 tool) {
        super.method_9556(world, player, pos, state, be, tool);
        if (world.field_9236) removeLightsIfAny(pos);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!world.field_9236) return;
        if (!newState.method_27852(this)) removeLightsIfAny(pos);
    }

    @Override
    public void method_9586(class_1937 world, class_2338 pos, net.minecraft.class_1927 explosion) {
        super.method_9586(world, pos, explosion);
        if (world.field_9236) removeLightsIfAny(pos);
    }


    private static void ensureHooks() {
        if (hooks) return;
        hooks = true;

        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            rescanPending = true; rendererWasReady = false;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            for (LightRenderHandle<AreaLightData> h : AREA_HANDLES.values()) if (h != null && h.isValid()) h.close();
            for (LightRenderHandle<PointLightData> h : POINT_HANDLES.values()) if (h != null && h.isValid()) h.close();
            AREA_HANDLES.clear(); POINT_HANDLES.clear(); AREA_DATA.clear(); POINT_DATA.clear(); FLICKER.clear();
            rescanPending = false; rendererWasReady = false;
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world == null || chunk == null) return;
            if (VeilRenderSystem.renderer() == null || VeilRenderSystem.renderer().getLightRenderer() == null) return;
            class_1923 cpos = chunk.method_12004();
            int minY = world.method_31607(), maxY = world.method_31600(), sx = cpos.method_8326(), sz = cpos.method_8328();
            for (int y = minY; y < maxY; y++)
                for (int x = 0; x < 16; x++)
                    for (int z = 0; z < 16; z++) {
                        class_2338 bp = new class_2338(sx + x, y, sz + z);
                        class_2680 st = world.method_8320(bp);
                        if (st.method_26204() instanceof TerminalBlock) spawnLightsIfNeeded(world, bp, st);
                    }
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (world == null || chunk == null) return;
            class_1923 cpos = chunk.method_12004();
            List<class_2338> toRemove = new ArrayList<>();
            for (class_2338 p : AREA_HANDLES.keySet())
                if ((p.method_10263() >> 4) == cpos.field_9181 && (p.method_10260() >> 4) == cpos.field_9180) toRemove.add(p);
            for (class_2338 p : toRemove) removeLightsIfAny(p);
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client == null || client.method_1493()) return;
            boolean rendererReady = VeilRenderSystem.renderer() != null && VeilRenderSystem.renderer().getLightRenderer() != null;
            if (rendererReady && !rendererWasReady) rescanPending = true;
            rendererWasReady = rendererReady;

            if (rescanPending && client.field_1687 != null && client.field_1724 != null && rendererReady) {
                var w = client.field_1687; var p = client.field_1724.method_24515(); int r = 4;
                for (int cx = (p.method_10263() >> 4) - r; cx <= (p.method_10263() >> 4) + r; cx++)
                    for (int cz = (p.method_10260() >> 4) - r; cz <= (p.method_10260() >> 4) + r; cz++) {
                        if (w.method_2935().method_12246(cx, cz) == null) continue;
                        class_1923 cp = new class_1923(cx, cz);
                        int minY = w.method_31607(), maxY = w.method_31600(), sx = cp.method_8326(), sz = cp.method_8328();
                        for (int y = minY; y < maxY; y++)
                            for (int x = 0; x < 16; x++)
                                for (int z = 0; z < 16; z++) {
                                    class_2338 bp = new class_2338(sx + x, y, sz + z);
                                    class_2680 st = w.method_8320(bp);
                                    if (st.method_26204() instanceof TerminalBlock) spawnLightsIfNeeded(w, bp, st);
                                }
                    }
                rescanPending = false;
            }
            if (!rendererReady) return;

            float dt = client.method_60646().method_60636();
            for (class_2338 pos : AREA_DATA.keySet().toArray(new class_2338[0])) {
                Flicker f = FLICKER.computeIfAbsent(pos, k -> { Flicker n = new Flicker(); n.phase = Phase.IDLE; n.cooldown = rand(5f, 30f); return n; });
                switch (f.phase) {
                    case IDLE -> {
                        f.cooldown -= dt;
                        applyBrightness(pos, BASE_BRIGHTNESS);
                        if (f.cooldown <= 0f) {
                            f.flashesLeft = 1 + RNG.nextInt(5);
                            f.offDur = rand(0.04f, 0.12f);
                            f.onDur  = rand(0.04f, 0.12f);
                            f.timer = 0f; f.phase = Phase.BURST_OFF;
                        }
                    }
                    case BURST_OFF -> {
                        f.timer += dt; applyBrightness(pos, 0f);
                        if (f.timer >= f.offDur) { f.timer = 0f; f.phase = Phase.BURST_ON; }
                    }
                    case BURST_ON -> {
                        f.timer += dt; applyBrightness(pos, BASE_BRIGHTNESS);
                        if (f.timer >= f.onDur) {
                            f.flashesLeft--;
                            if (f.flashesLeft <= 0) {
                                f.tailLeft = 1 + RNG.nextInt(3);
                                f.tailGap = rand(0.35f, 0.9f);
                                f.timer = 0f; f.phase = Phase.TAIL_WAIT;
                            } else {
                                f.offDur = rand(0.04f, 0.12f);
                                f.onDur  = rand(0.04f, 0.12f);
                                f.timer = 0f; f.phase = Phase.BURST_OFF;
                            }
                        }
                    }
                    case TAIL_WAIT -> {
                        f.timer += dt; applyBrightness(pos, BASE_BRIGHTNESS);
                        if (f.timer >= f.tailGap) {
                            f.timer = 0f;
                            f.offDur = rand(0.12f, 0.25f);
                            f.onDur  = rand(0.10f, 0.22f);
                            f.phase = Phase.TAIL_OFF;
                        }
                    }
                    case TAIL_OFF -> {
                        f.timer += dt; applyBrightness(pos, 0f);
                        if (f.timer >= f.offDur) { f.timer = 0f; f.phase = Phase.TAIL_ON; }
                    }
                    case TAIL_ON -> {
                        f.timer += dt; applyBrightness(pos, BASE_BRIGHTNESS);
                        if (f.timer >= f.onDur) {
                            f.tailLeft--;
                            if (f.tailLeft <= 0) {
                                f.settleTime = 0f; f.settleDur = rand(0.4f, 0.8f);
                                f.settleFrom = BASE_BRIGHTNESS; f.phase = Phase.SETTLE;
                            } else {
                                f.timer = 0f; f.tailGap = rand(0.35f, 0.9f); f.phase = Phase.TAIL_WAIT;
                            }
                        }
                    }
                    case SETTLE -> {
                        f.settleTime += dt;
                        float t = clamp01(f.settleTime / f.settleDur);
                        float b = lerp(f.settleFrom, BASE_BRIGHTNESS, smoothstep01(t));
                        applyBrightness(pos, b);
                        if (t >= 1f) { f.cooldown = rand(5f, 30f); f.phase = Phase.IDLE; }
                    }
                }
            }
        });
    }

    private static void applyBrightness(class_2338 pos, float b) {
        AreaLightData al = AREA_DATA.get(pos);
        if (al != null) al.setBrightness(b);
        PointLightData pl = POINT_DATA.get(pos);
        if (pl != null) pl.setBrightness(b);
        LightRenderHandle<AreaLightData> ah = AREA_HANDLES.get(pos);
        if (ah != null && ah.isValid()) ah.markDirty();
        LightRenderHandle<PointLightData> ph = POINT_HANDLES.get(pos);
        if (ph != null && ph.isValid()) ph.markDirty();
    }

    private static float rand(float a, float b) { return a + (b - a) * RNG.nextFloat(); }
    private static float lerp(float a, float b, float t) { return a + (b - a) * t; }
    private static float clamp01(float v) { return v < 0f ? 0f : (v > 1f ? 1f : v); }
    private static float smoothstep01(float x) { x = clamp01(x); return x * x * (3f - 2f * x); }
}
