package net.kronoz.odyssey.block.custom;

import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import java.util.Map;
import java.util.WeakHashMap;

public class TransformingAlterBlock extends class_2248 {
    private static final class_5321<class_1937> VOID_DIM =
            class_5321.method_29179(class_7924.field_41223, class_2960.method_60655("odyssey", "void"));

    private static final double TX = 328.5;
    private static final double TY = 147.0;
    private static final double TZ = 183.5;
    private static final long PROTECT_TICKS = 50 * 20; // 50 seconds at 20 TPS

    private static final Map<class_3222, Long> FALL_PROTECT = new WeakHashMap<>();

    public TransformingAlterBlock(class_2251 settings) {
        super(settings);

        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (entity instanceof class_3222 sp) {
                if (source.method_48789(class_8103.field_42250)) {
                    Long until = FALL_PROTECT.get(sp);
                    if (until != null && sp.method_37908().method_8510() < until) {
                        return false;
                    }
                }
            }
            return true;
        });
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos,
                              class_1657 player, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;
        if (!(player instanceof class_3222 sp)) return class_1269.field_5811;

        class_3218 dest = sp.method_5682().method_3847(VOID_DIM);
        if (dest == null) return class_1269.field_21466;

        doTeleport(sp, dest);
        return class_1269.field_5812;
    }

    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (world.field_9236) return;
        if (!(entity instanceof class_3222 sp)) return;

        class_3218 dest = sp.method_5682().method_3847(VOID_DIM);
        if (dest == null) return;

        doTeleport(sp, dest);
    }

    private static void doTeleport(class_3222 sp, class_3218 dest) {
        sp.field_6017 = 0.0f;
        sp.method_14251(dest, TX, TY, TZ, sp.method_36454(), sp.method_36455());
        sp.method_6092(new class_1293(class_1294.field_5902, 40, 0, false, false));

        FALL_PROTECT.put(sp, dest.method_8510() + PROTECT_TICKS);
    }
}
