package net.kronoz.odyssey.block.custom;

import net.kronoz.odyssey.entity.apostasy.ApostasyEntity;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import java.util.Comparator;

public class UnholyAlterBlock extends class_2248 {

    public static final class_2746 SPAWNED = class_2746.method_11825("spawned");
    public static final class_2753 FACING = class_2741.field_12525;

    public UnholyAlterBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9595().method_11664()
                .method_11657(FACING, class_2350.field_11036)
                .method_11657(SPAWNED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, SPAWNED);
    }

    @Override
    protected boolean method_9506(class_2680 state) {
        return state.method_11654(SPAWNED);
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(SPAWNED) ? 15 : 0;
    }

    @Override
    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return method_9524(state, world, pos, direction);
    }

    /**
     * Spawn Apostasy once per block
     */
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236 || state.method_11654(SPAWNED)) return class_1269.field_5812;

        if (!(world instanceof class_3218 serverWorld)) return class_1269.field_5812;

        // Check if Apostasy already exists nearby
        class_238 checkBox = new class_238(pos).method_1009(2, 3, 2);
        boolean exists = !serverWorld.method_8390(ApostasyEntity.class, checkBox, e -> true).isEmpty();

        if (!exists) {
            ApostasyEntity apostasy = ModEntities.APOSTASY.method_5883(serverWorld);
            if (apostasy != null) {
                class_2350 facing = state.method_11654(FACING);
                float yaw = switch (facing) {
                    case field_11043 -> 180f;
                    case field_11035 -> 0f;
                    case field_11039 -> 90f;
                    case field_11034 -> 270f;
                    default -> 0f;
                };
                apostasy.method_5808(
                        pos.method_10263() + 0.5,
                        pos.method_10264() + 1,
                        pos.method_10260() + 0.5,
                        yaw,
                        0
                );
                serverWorld.method_8649(apostasy);

                // Update block state so it won't spawn again

                world.method_8652(pos, state.method_11657(SPAWNED, true), class_2248.field_31036 | class_2248.field_31031);
                world.method_8408(pos.method_10074(), this);

            }
        }

        return class_1269.field_5812;
    }
}
