package net.kronoz.odyssey.cca;

import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.net.BodyModPackets;
import net.kronoz.odyssey.systems.data.BodyPartRegistry;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BodyModComponentImpl implements BodyModComponent, AutoSyncedComponent {
    private final class_1657 player;
    private final Map<String, class_2960> equipped = new HashMap<>();

    public BodyModComponentImpl(class_1657 player){ this.player = player; }

    @Override public Map<String, class_2960> getEquipped(){ return Collections.unmodifiableMap(equipped); }

    @Override public void setPart(String slot, class_2960 partId) {
        clearSlot(slot);
        equipped.put(slot, partId);
        applyAttr(slot, partId);
    }

    @Override public void clearSlot(String slot) {
        removeAttr(slot);
        equipped.remove(slot);
    }

    private class_2960 key(String slot, String kind){
        return Odyssey.id("bodymod_" + slot + "_" + kind);
    }

    private void applyAttr(String slot, class_2960 partId) {
        BodyPartRegistry.Part p = BodyPartRegistry.get(partId);
        if (p == null) return;

        if (p.speed != 0.0) {
            var inst = player.method_5996(class_5134.field_23719);
            if (inst != null) {
                inst.method_6200(key(slot,"speed"));
                inst.method_26837(new class_1322(
                        key(slot,"speed"),
                        (double)p.speed,
                        class_1322.class_1323.field_6330));
            }
        }
        if (p.attack != 0.0) {
            var inst = player.method_5996(class_5134.field_23721);
            if (inst != null) {
                inst.method_6200(key(slot,"attack"));
                inst.method_26837(new class_1322(
                        key(slot,"attack"),
                        (double)p.attack,
                        class_1322.class_1323.field_6328));
            }
        }
    }

    private void removeAttr(String slot) {
        var sp = player.method_5996(class_5134.field_23719);
        var ad = player.method_5996(class_5134.field_23721);
        if (sp != null) sp.method_6200(key(slot,"speed"));
        if (ad != null) ad.method_6200(key(slot,"attack"));
    }

    @Override public void sync(class_1657 player) {
        if (player instanceof class_3222 sp) {
            net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking.send(sp,
                    new BodyModPackets.SyncBodyS2C(
                            this.player.method_5667(),
                            new HashMap<>(equipped)));
        }
    }

    @Override public void clientApply(Map<String, class_2960> map) {
        equipped.clear();
        equipped.putAll(map);
    }

    @Override public void readFromNbt(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        equipped.clear();
        for (String k : tag.method_10541()) {
            if (tag.method_10545(k)) equipped.put(k, class_2960.method_60654(tag.method_10558(k)));
        }
    }

    @Override public void writeToNbt(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        for (var e : equipped.entrySet()) {
            tag.method_10582(e.getKey(), e.getValue().toString());
        }
    }

}
