package net.kronoz.odyssey.client;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.kronoz.odyssey.entity.LiftPlatformEntity;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_310;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class ClientElevatorAssist {

    private static final class S {
        double cx,cy,cz,vy; int w,l,h; boolean init=false;
    }
    private static final Map<UUID,S> SMOOTH = new HashMap<>();

    public static void init(){
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_1657 p = class_310.method_1551().field_1724;
            if(p==null || p.method_37908()==null) return;

            var world = p.method_37908();
            var nearby = world.method_8390(
                    LiftPlatformEntity.class,
                    p.method_5829().method_1009(48, 24, 48),
                    e -> true
            );

            for(var lp : nearby){
                var dt = lp.method_5841();
                float rCX = dt.method_12789(LiftPlatformEntity.CX);
                float rCY = dt.method_12789(LiftPlatformEntity.CY);
                float rCZ = dt.method_12789(LiftPlatformEntity.CZ);
                float rVY = dt.method_12789(LiftPlatformEntity.VY);
                int rW = dt.method_12789(LiftPlatformEntity.DW);
                int rL = dt.method_12789(LiftPlatformEntity.DL);
                int rH = dt.method_12789(LiftPlatformEntity.DH);

                S s = SMOOTH.computeIfAbsent(lp.method_5667(), k -> new S());
                if(!s.init){
                    s.cx=rCX; s.cy=rCY; s.cz=rCZ; s.vy=rVY; s.w=rW; s.l=rL; s.h=rH; s.init=true;
                }else{
                    double a=0.8;
                    s.cx = a*s.cx + (1-a)*rCX;
                    s.cy = a*s.cy + (1-a)*rCY;
                    s.cz = a*s.cz + (1-a)*rCZ;
                    s.vy = a*s.vy + (1-a)*rVY;
                    s.w=rW; s.l=rL; s.h=rH;
                }

                double halfW = s.w/2.0, halfL = s.l/2.0;
                class_238 top = new class_238(s.cx-halfW, s.cy+s.h-1, s.cz-halfL, s.cx+halfW, s.cy+s.h, s.cz+halfL).method_1009(0.01,0.02,0.01);

                var pb = p.method_5829();
                boolean horiz = pb.field_1320 > top.field_1323 && pb.field_1323 < top.field_1320 && pb.field_1324 > top.field_1321 && pb.field_1321 < top.field_1324;
                double feet = pb.field_1322;
                boolean onTop = horiz && feet >= top.field_1322-0.5 && feet <= top.field_1325+0.25;

                if(onTop){
                    // exact surface (no +0.001)
                    double targetFeet = top.field_1325;
                    double gap = targetFeet - feet;

                    final double SNAP_TOL = 0.001;   // snap if within ~1/20th block
                    final double LIFT_CAP = 1.00;    // max up correction per tick
                    final double DROP_CAP = 1.00;    // max down correction per tick

                    if(gap > 0){
                        if(gap <= SNAP_TOL){
                            // snap exactly to the surface (perfect height)
                            p.method_5814(p.method_23317(), p.method_23318() + gap, p.method_23321());
                        }else{
                            // still approach smoothly, capped
                            double lift = Math.min(gap * 0.6, LIFT_CAP);
                            p.method_5814(p.method_23317(), p.method_23318() + lift, p.method_23321());
                        }
                    }else if(gap < 0){
                        // if we’re hovering above, gently settle
                        double drop = Math.min(-gap * 0.5, DROP_CAP);
                        p.method_5814(p.method_23317(), p.method_23318() - drop, p.method_23321());
                    }

                    // blend vertical velocity with platform vy
                    double curVy = p.method_18798().field_1351;
                    double nvy = Math.max(s.vy, curVy*0.85);
                    p.method_18800(p.method_18798().field_1352, nvy, p.method_18798().field_1350);
                    p.field_6017 = 0f;
                }
            }
        });
    }
}
