package net.kronoz.odyssey.config;

import eu.midnightdust.lib.config.MidnightConfig;
import net.kronoz.odyssey.Odyssey;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public final class OdysseyConfigScreen extends class_437 {
    private final class_437 parent;

    private final List<Row> scrollRows = new ArrayList<>();
    private int contentStartY;
    private int contentHeight;
    private double scroll;
    private static final int VIEW_TOP_MARGIN = 8;
    private static final int VIEW_BOTTOM_MARGIN = 28;

    private class_4286 enableOverride;
    private class_4286 renderOverlay;

    public OdysseyConfigScreen(class_437 parent) {
        super(class_2561.method_43470("Odyssey — First-Person Arm Tuning"));
        this.parent = parent;
    }

    @Override
    protected void method_25426() {
        final int w = this.field_22789;
        final int h = this.field_22790;
        final int colW = 160;
        final int gap = 12;
        final int startX = (w - (colW * 2 + gap)) / 2;

        this.method_37063(new Label(
                w / 2 - 100, h / 6 - 18, 200, 10,
                class_2561.method_43470("First-person arm & item pose").method_27692(class_124.field_1065)
        ));

        int x = startX;
        int y = h / 6;
        contentStartY = y;

        enableOverride = class_4286.method_54787(class_2561.method_43470("Enable FP override"), this.field_22793)
                .method_54789(x, y).method_54794(OdysseyConfig.enableFirstPersonOverride).method_54788();
        addScrollable(enableOverride, x, y);

        renderOverlay = class_4286.method_54787(class_2561.method_43470("Render arm overlay (FP)"), this.field_22793)
                .method_54789(x + colW + gap, y).method_54794(OdysseyConfig.renderArmOverlay).method_54788();
        addScrollable(renderOverlay, x + colW + gap, y);

        y += 26;

        x = startX;
        y = addSectionLabel("Base Offsets (Held Item)", x, y);
        y = addFloatSlider(x, y, colW, "Base X", -1.5f, 1.5f, OdysseyConfig.heldBaseX, v -> OdysseyConfig.heldBaseX = v);
        y = addFloatSlider(x, y, colW, "Base Y", -1.5f, 1.0f,  OdysseyConfig.heldBaseY, v -> OdysseyConfig.heldBaseY = v);
        y = addFloatSlider(x, y, colW, "Base Z", -2.0f, -0.1f, OdysseyConfig.heldBaseZ, v -> OdysseyConfig.heldBaseZ = v);
        y = addFloatSlider(x, y, colW, "Scale",   0.5f,  1.5f,  OdysseyConfig.heldScale, v -> OdysseyConfig.heldScale = v);

        y = addSectionLabel("Follow-Down Curve", x, y + 6);
        y = addFloatSlider(x, y, colW, "Drop Y Max",   0.00f, 0.60f, OdysseyConfig.dropYMax,   v -> OdysseyConfig.dropYMax = v);
        y = addFloatSlider(x, y, colW, "Push Z Max",   0.00f, 0.80f, OdysseyConfig.pushZMax,   v -> OdysseyConfig.pushZMax = v);
        y = addFloatSlider(x, y, colW, "Inward X Max", 0.00f, 0.30f, OdysseyConfig.inwardXMax, v -> OdysseyConfig.inwardXMax = v);

        int x2 = startX + colW + gap;
        int y2 = h / 6 + 26;

        y2 = addSectionLabel("Swing / Equip Translations (Held)", x2, y2);
        y2 = addFloatSlider(x2, y2, colW, "Swing X", -0.30f, 0.30f, OdysseyConfig.swingX, v -> OdysseyConfig.swingX = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Y", -0.30f, 0.30f, OdysseyConfig.swingY, v -> OdysseyConfig.swingY = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Z", -0.50f, 0.30f, OdysseyConfig.swingZ, v -> OdysseyConfig.swingZ = v);
        y2 = addFloatSlider(x2, y2, colW, "Equip X", -0.30f, 0.30f, OdysseyConfig.equipX, v -> OdysseyConfig.equipX = v);
        y2 = addFloatSlider(x2, y2, colW, "Equip Y", -0.30f, 0.30f, OdysseyConfig.equipY, v -> OdysseyConfig.equipY = v);
        y2 = addFloatSlider(x2, y2, colW, "Equip Z", -0.50f, 0.30f, OdysseyConfig.equipZ, v -> OdysseyConfig.equipZ = v);

        y2 = addSectionLabel("Intensities", x2, y2 + 6);
        y2 = addFloatSlider(x2, y2, colW, "Swing Intensity", 0.0f, 3.0f, OdysseyConfig.swingIntensity, v -> OdysseyConfig.swingIntensity = v);
        y2 = addFloatSlider(x2, y2, colW, "Equip Intensity", 0.0f, 3.0f, OdysseyConfig.equipIntensity, v -> OdysseyConfig.equipIntensity = v);

        y2 = addSectionLabel("Rotations (deg)", x2, y2 + 6);
        y2 = addFloatSlider(x2, y2, colW, "Base Rot X", -90f, 90f, OdysseyConfig.heldRotX, v -> OdysseyConfig.heldRotX = v);
        y2 = addFloatSlider(x2, y2, colW, "Base Rot Y", -90f, 90f, OdysseyConfig.heldRotY, v -> OdysseyConfig.heldRotY = v);
        y2 = addFloatSlider(x2, y2, colW, "Base Rot Z", -90f, 90f, OdysseyConfig.heldRotZ, v -> OdysseyConfig.heldRotZ = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Rot X", 0f, 120f, OdysseyConfig.swingRotXDeg, v -> OdysseyConfig.swingRotXDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Rot Y", 0f, 120f, OdysseyConfig.swingRotYDeg, v -> OdysseyConfig.swingRotYDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Rot Z", 0f, 120f, OdysseyConfig.swingRotZDeg, v -> OdysseyConfig.swingRotZDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Equip Roll",  0f, 45f,  OdysseyConfig.equipRollDeg, v -> OdysseyConfig.equipRollDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Pitch X",     0f, 90f,  OdysseyConfig.pitchXDeg,    v -> OdysseyConfig.pitchXDeg = v);

        y2 = addSectionLabel("Arm (FP Overlay) — Base", x2, y2 + 6);
        y2 = addFloatSlider(x2, y2, colW, "Arm Base X", -1.0f, 1.0f, OdysseyConfig.armBaseX, v -> OdysseyConfig.armBaseX = v);
        y2 = addFloatSlider(x2, y2, colW, "Arm Base Y", -1.0f, 1.0f, OdysseyConfig.armBaseY, v -> OdysseyConfig.armBaseY = v);
        y2 = addFloatSlider(x2, y2, colW, "Arm Base Z", -1.5f, 0.3f, OdysseyConfig.armBaseZ, v -> OdysseyConfig.armBaseZ = v);
        y2 = addFloatSlider(x2, y2, colW, "Arm Scale",   0.5f, 1.5f,  OdysseyConfig.armScale, v -> OdysseyConfig.armScale = v);

        y2 = addSectionLabel("Arm (FP Overlay) — Rotations (deg)", x2, y2 + 6);
        y2 = addFloatSlider(x2, y2, colW, "Base Rot X", -90f, 90f, OdysseyConfig.armRotX, v -> OdysseyConfig.armRotX = v);
        y2 = addFloatSlider(x2, y2, colW, "Base Rot Y", -90f, 90f, OdysseyConfig.armRotY, v -> OdysseyConfig.armRotY = v);
        y2 = addFloatSlider(x2, y2, colW, "Base Rot Z", -90f, 90f, OdysseyConfig.armRotZ, v -> OdysseyConfig.armRotZ = v);

        y2 = addSectionLabel("Arm (FP Overlay) — Swing/Equip/Pitch (deg)", x2, y2 + 6);
        y2 = addFloatSlider(x2, y2, colW, "Swing Rot X", 0f, 120f, OdysseyConfig.armSwingRotXDeg, v -> OdysseyConfig.armSwingRotXDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Rot Y", 0f, 120f, OdysseyConfig.armSwingRotYDeg, v -> OdysseyConfig.armSwingRotYDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Swing Rot Z", 0f, 120f, OdysseyConfig.armSwingRotZDeg, v -> OdysseyConfig.armSwingRotZDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Equip Roll",  0f, 45f,  OdysseyConfig.armEquipRollDeg,  v -> OdysseyConfig.armEquipRollDeg = v);
        y2 = addFloatSlider(x2, y2, colW, "Pitch X",     0f, 90f,  OdysseyConfig.armPitchXDeg,     v -> OdysseyConfig.armPitchXDeg = v);

        // Done (non-scrolled)
        int bottomY = Math.max(y, y2) + 16;
        this.method_37063(class_4185.method_46430(class_2561.method_43470("Done").method_27692(class_124.field_1060), b -> closeAndSave())
                .method_46434(w / 2 - 75, Math.min(bottomY, h - 24), 150, 20).method_46431());

        contentHeight = Math.max(y, y2) - contentStartY;
        clampScroll();
        applyScrollToWidgets();
    }

    private int addSectionLabel(String title, int x, int y) {
        Label lab = new Label(x, y, 160, 10, class_2561.method_43470(title).method_27692(class_124.field_1054));
        addScrollable(lab, x, y);
        return y + 12;
    }

    private int addFloatSlider(int x, int y, int width, String label, float min, float max, float current, Consumer<Float> onChange) {
        FloatSlider s = new FloatSlider(x, y, width, 20, class_2561.method_43470(label), current, min, max, onChange);
        addScrollable(s, x, y);
        return y + 24;
    }

    private void addScrollable(class_339 w, int baseX, int baseY) {
        this.method_37063(w);
        scrollRows.add(new Row(w, baseX, baseY));
    }

    private void closeAndSave() {
        OdysseyConfig.enableFirstPersonOverride = enableOverride.method_20372();
        OdysseyConfig.renderArmOverlay = renderOverlay.method_20372();
        MidnightConfig.write(Odyssey.MODID);
        class_310.method_1551().method_1507(parent);
    }

    @Override public void method_25419() { closeAndSave(); }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int viewTop = contentStartY - VIEW_TOP_MARGIN;
        int viewBottom = this.field_22790 - VIEW_BOTTOM_MARGIN;
        if (mouseY >= viewTop && mouseY <= viewBottom) {
            scroll -= verticalAmount * 16.0;
            clampScroll();
            applyScrollToWidgets();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void clampScroll() {
        int viewHeight = (this.field_22790 - VIEW_BOTTOM_MARGIN) - (contentStartY - VIEW_TOP_MARGIN);
        int max = Math.max(0, contentHeight - viewHeight);
        if (scroll < 0) scroll = 0;
        if (scroll > max) scroll = max;
    }

    private void applyScrollToWidgets() {
        int viewTop = contentStartY - VIEW_TOP_MARGIN;
        int viewBottom = this.field_22790 - VIEW_BOTTOM_MARGIN;

        for (Row r : scrollRows) {
            int newY = (int)Math.round(r.baseY - scroll);
            r.w.method_46421(r.baseX);
            r.w.method_46419(newY);
            r.w.field_22764 = newY + r.w.method_25364() >= viewTop && newY <= viewBottom;
        }
    }

    @Override
    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, contentStartY - 18, 0xFFFFFF);
        drawScrollbar(ctx);
    }

    private void drawScrollbar(class_332 ctx) {
        int viewTop = contentStartY - VIEW_TOP_MARGIN;
        int viewBottom = this.field_22790 - VIEW_BOTTOM_MARGIN;
        int viewHeight = viewBottom - viewTop;
        if (contentHeight <= viewHeight) return;

        int barX = this.field_22789 - 6;
        int barW = 3;

        double ratio = viewHeight / (double) contentHeight;
        int thumbH = Math.max(16, (int)Math.round(viewHeight * ratio));
        int maxScroll = contentHeight - viewHeight;
        int thumbY = (int)Math.round(viewTop + (scroll / maxScroll) * (viewHeight - thumbH));

        ctx.method_25294(barX, viewTop, barX + barW, viewBottom, 0x55000000);
        ctx.method_25294(barX, thumbY, barX + barW, thumbY + thumbH, 0xFFAAAAAA);
    }

    private static final class Row {
        final class_339 w;
        final int baseX, baseY;
        Row(class_339 w, int baseX, int baseY) { this.w = w; this.baseX = baseX; this.baseY = baseY; }
    }

    private static final class Label extends class_339 {
        private final class_2561 text;
        Label(int x, int y, int w, int h, class_2561 text) {
            super(x, y, w, h, text);
            this.text = text;
            this.field_22763 = false;
            this.field_22764 = true;
        }
        @Override
        protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            ctx.method_51439(class_310.method_1551().field_1772, text, method_46426(), method_46427(), 0xFFFFFF, false);
        }

        @Override
        protected void method_47399(class_6382 builder) {

        }
    }

    private static final class FloatSlider extends class_357 {
        private final String label;
        private final float min, max;
        private float valueF;
        private final Consumer<Float> onChange;

        FloatSlider(int x, int y, int w, int h, class_2561 label, float current, float min, float max, Consumer<Float> onChange) {
            super(x, y, w, h, label, normalize(current, min, max));
            this.label = label.getString();
            this.min = min;
            this.max = max;
            this.valueF = current;
            this.onChange = onChange;
            method_25346();
        }
        @Override protected void method_25346() {
            this.method_25355(class_2561.method_43470(label + ": " + String.format("%.3f", valueF)));
        }
        @Override protected void method_25344() {
            this.valueF = denormalize(this.field_22753, min, max);
            onChange.accept(this.valueF);
            method_25346();
        }
        private static double normalize(float v, float min, float max) {
            return Math.max(0d, Math.min(1d, (v - min) / (max - min)));
        }
        private static float denormalize(double n, float min, float max) {
            return (float)(min + n * (max - min));
        }
    }
}
