package net.kronoz.odyssey.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;

public class DebrisBlockEntity extends class_1297 {
    private static final class_2940<Integer> LIFE = class_2945.method_12791(DebrisBlockEntity.class, class_2943.field_13327);
    private static final class_2940<Integer> BLOCK_ID = class_2945.method_12791(DebrisBlockEntity.class, class_2943.field_13327);

    private class_2680 state = class_2246.field_10499.method_9564();
    private int lifetime = 60;
    private float rollX, rollY, rollZ;
    private float avx, avy, avz;
    private boolean onGroundDamping = true;

    public DebrisBlockEntity(class_1299<? extends DebrisBlockEntity> type, class_1937 world) {
        super(type, world);
        this.field_5960 = false;
        this.method_5875(false);
        this.field_23807 = true;
    }

    public void init(class_2680 st, int life) {
        this.state = st;
        this.lifetime = life;
        this.method_5841().method_12778(LIFE, life);
        this.method_5841().method_12778(BLOCK_ID, net.minecraft.class_2248.method_9507(st));
    }

    public void setAngularVelocity(float xDegPerTick, float yDegPerTick, float zDegPerTick) {
        this.avx = xDegPerTick;
        this.avy = yDegPerTick;
        this.avz = zDegPerTick;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(LIFE, 60);
        builder.method_56912(BLOCK_ID, net.minecraft.class_2248.method_9507(this.state));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) return;

        int life = this.method_5841().method_12789(LIFE);
        life--;
        if (life <= 0) { this.method_31472(); return; }
        this.method_5841().method_12778(LIFE, life);

        // gravity + move with collisions
        var vel = this.method_18798();
        vel = vel.method_1031(0, -0.04, 0);
        double damp = this.method_24828() ? 0.65 : 0.98;
        vel = vel.method_18805(damp, 0.98, damp);
        this.method_18799(vel);
        this.method_5784(class_1313.field_6308, this.method_18798());

        // bounce a little on ground
        if (this.field_5976) this.method_18800(-vel.field_1352 * 0.4, vel.field_1351, -vel.field_1350 * 0.4);
        if (this.field_5992 && vel.field_1351 < 0) this.method_18800(vel.field_1352, -vel.field_1351 * 0.4, vel.field_1350);

        // spin
        rollX += avx;
        rollY += avy;
        rollZ += avz;
    }

    public class_2680 getBlockStateRender() {
        int id = this.method_5841().method_12789(BLOCK_ID);
        return net.minecraft.class_2248.method_9531(id);
    }

    public float getRollX() { return rollX; }
    public float getRollY() { return rollY; }
    public float getRollZ() { return rollZ; }

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("life")) this.lifetime = nbt.method_10550("life");
        if (nbt.method_10545("raw")) {
            int raw = nbt.method_10550("raw");
            this.state = net.minecraft.class_2248.method_9531(raw);
        }
        this.method_5841().method_12778(LIFE, this.lifetime);
        this.method_5841().method_12778(BLOCK_ID, net.minecraft.class_2248.method_9507(this.state));
        this.rollX = nbt.method_10583("rx");
        this.rollY = nbt.method_10583("ry");
        this.rollZ = nbt.method_10583("rz");
        this.avx = nbt.method_10583("avx");
        this.avy = nbt.method_10583("avy");
        this.avz = nbt.method_10583("avz");
    }
    private void pullDownColumnBlocks(class_3218 sw, class_2338 pos, int scanUp, int maxPull) {
        int pulled = 0;
        class_2338.class_2339 m = new class_2338.class_2339();
        for (int dy = 1; dy <= scanUp && pulled < maxPull; dy++) {
            m.method_10103(pos.method_10263(), pos.method_10264() + dy, pos.method_10260());
            var st = sw.method_8320(m);
            if (st.method_26215()) continue;
            var blk = st.method_26204();
            if (blk == net.minecraft.class_2246.field_9987 || blk == net.minecraft.class_2246.field_10499) continue;
            if (st.method_26220(sw, m).method_1110()) continue;

            sw.method_8652(m, net.minecraft.class_2246.field_10124.method_9564(), 3);
            var f = net.minecraft.class_1540.method_40005(sw, m, st);
            if (f != null) {
                f.field_7193 = false;
                try { f.method_49181(); } catch (Throwable ignored) {}
                double spread = 0.35;
                f.method_18800(
                        (this.field_5974.method_43058() - 0.5) * spread,
                        -0.2 - this.field_5974.method_43058() * 0.2,
                        (this.field_5974.method_43058() - 0.5) * spread
                );
            }
            pulled++;
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("life", this.method_5841().method_12789(LIFE));
        nbt.method_10569("raw", net.minecraft.class_2248.method_9507(getBlockStateRender()));
        nbt.method_10548("rx", rollX);
        nbt.method_10548("ry", rollY);
        nbt.method_10548("rz", rollZ);
        nbt.method_10548("avx", avx);
        nbt.method_10548("avy", avy);
        nbt.method_10548("avz", avz);
    }
    @Override
    public boolean method_5640(double distance) { return true; }

    @Override
    public class_238 method_5830() {
        return this.method_5829().method_1014(1.0);
    }
}
