package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.init.ModBlockEntities;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.*;

public class ElevatorBlockEntity extends class_2586 {
    public static class Part { public class_2338 off; public class_2680 state; public Part(class_2338 o, class_2680 s){ off=o; state=s; } }

    private final List<Part> parts = new ArrayList<>();
    private UUID platformId = null;
    private double speed = 0.003;
    private class_2338 origin = class_2338.field_10980;

    public ElevatorBlockEntity(class_2338 pos, class_2680 state){ super(ModBlockEntities.ELEVATOR_BE,pos,state); }
    private class_1937 w(){ return Objects.requireNonNull(method_10997()); }
    public static void serverTick(class_1937 w, class_2338 pos, class_2680 st, ElevatorBlockEntity be){}

    public void start(class_3218 sw, int dir){
        origin = this.field_11867;
        scan(sw);
        if(parts.isEmpty()) return;
        removeBlocks(sw);
        LiftPlatformEntity p = ensurePlatform(sw);
        if(p==null) return;
        p.configure(origin, copyParts(), speed, dir);
        method_5431();
    }

    private List<LiftPlatformEntity.Part> copyParts(){
        List<LiftPlatformEntity.Part> out = new ArrayList<>();
        for(Part p: parts) out.add(new LiftPlatformEntity.Part(p.off, p.state));
        return out;
    }

    private void scan(class_3218 sw){
        parts.clear();
        HashSet<class_2338> vis = new HashSet<>();
        ArrayDeque<class_2338> q = new ArrayDeque<>();
        q.add(this.field_11867); vis.add(this.field_11867);
        class_2248 self = w().method_8320(this.field_11867).method_26204();
        while(!q.isEmpty()){
            class_2338 c=q.pollFirst();
            class_2680 s=sw.method_8320(c);
            if(s.method_26204()!=self) continue;
            parts.add(new Part(c.method_10059(this.field_11867), s));
            for(class_2338 n: new class_2338[]{c.method_10095(),c.method_10072(),c.method_10078(),c.method_10067(),c.method_10084(),c.method_10074()}){
                if(!vis.contains(n) && sw.method_8320(n).method_26204()==self){ vis.add(n); q.add(n); }
            }
        }
    }

    private void removeBlocks(class_3218 sw){
        class_2248 self = w().method_8320(this.field_11867).method_26204();
        for(Part p: parts){
            class_2338 at = origin.method_10081(p.off);
            if(sw.method_8320(at).method_26204()==self){
                sw.method_8652(at, net.minecraft.class_2246.field_10124.method_9564(), class_2248.field_31036);
            }
        }
    }

    private LiftPlatformEntity ensurePlatform(class_3218 sw){
        if(platformId==null || !(sw.method_14190(platformId) instanceof LiftPlatformEntity)){
            LiftPlatformEntity e = ModEntities.LIFT_PLATFORM.method_5883(sw);
            if(e==null) return null;
            e.method_5808(origin.method_10263()+0.5, origin.method_10264(), origin.method_10260()+0.5, 0,0);
            sw.method_8649(e);
            platformId = e.method_5667();
            return e;
        }
        return (LiftPlatformEntity) sw.method_14190(platformId);
    }

    @Override protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup){
        class_2499 list = new class_2499();
        for(Part p: parts){
            class_2487 t=new class_2487();
            t.method_10569("x",p.off.method_10263()); t.method_10569("y",p.off.method_10264()); t.method_10569("z",p.off.method_10260());
            t.method_10566("state", class_2512.method_10686(p.state));
            list.add(t);
        }
        nbt.method_10566("parts",list);
        if(platformId!=null) nbt.method_25927("pid",platformId);
        nbt.method_10549("spd",speed);
        nbt.method_10569("ox", origin.method_10263()); nbt.method_10569("oy", origin.method_10264()); nbt.method_10569("oz", origin.method_10260());
    }

    @Override protected void method_11014(class_2487 nbt, class_7225.class_7874 lookup){
        parts.clear();
        if(nbt.method_10573("parts", class_2520.field_33259)){
            class_2499 list=nbt.method_10554("parts", class_2520.field_33260);
            for(int i=0;i<list.size();i++){
                class_2487 t=list.method_10602(i);
                class_2338 off = new class_2338(t.method_10550("x"),t.method_10550("y"),t.method_10550("z"));
                class_2680 st = class_2512.method_10681(lookup.method_46762(class_7924.field_41254), t.method_10562("state"));
                parts.add(new Part(off, st));
            }
        }
        if(nbt.method_25928("pid")) platformId=nbt.method_25926("pid");
        if(nbt.method_10545("spd")) speed=nbt.method_10574("spd");
        int ox = nbt.method_10545("ox")?nbt.method_10550("ox"):this.field_11867.method_10263();
        int oy = nbt.method_10545("oy")?nbt.method_10550("oy"):this.field_11867.method_10264();
        int oz = nbt.method_10545("oz")?nbt.method_10550("oz"):this.field_11867.method_10260();
        origin = new class_2338(ox,oy,oz);
    }
}
