package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_8113;
import java.util.*;

public class LiftPlatformEntity extends class_1297 {
    public static class Part { public class_2338 off; public class_2680 state; public Part(class_2338 o, class_2680 s){ off=o; state=s; } }

    private static final net.minecraft.class_2248 STOP_MARKER = class_2246.field_27119;

    public static final class_2940<Float> CX = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> CY = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> CZ = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> VY = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Integer> DW = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13327);
    public static final class_2940<Integer> DL = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13327);
    public static final class_2940<Integer> DH = class_2945.method_12791(LiftPlatformEntity.class, class_2943.field_13327);

    private final List<Part> parts = new ArrayList<>();
    private final Map<class_2338, UUID> displayIds = new HashMap<>();
    private final Map<class_2338, UUID> colliderIds = new HashMap<>();
    private boolean moving = false;
    private int dir = 0;
    private double speed = 0.05;
    private class_2338 origin = class_2338.field_10980;
    private class_243 base = class_243.field_1353;

    public LiftPlatformEntity(class_1299<? extends class_1297> type, class_1937 world){ super(type, world); this.field_5960=true; }

    @Override protected void method_5693(class_2945.class_9222 b){
        b.method_56912(CX, 0f); b.method_56912(CY, 0f); b.method_56912(CZ, 0f); b.method_56912(VY, 0f);
        b.method_56912(DW, 1); b.method_56912(DL, 1); b.method_56912(DH, 1);
    }

    public void configure(class_2338 originBlock, List<Part> p, double spd, int direction){
        origin = originBlock;
        base = new class_243(origin.method_10263(), origin.method_10264(), origin.method_10260());
        method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
        clearDisplays(); clearColliders();
        parts.clear(); parts.addAll(p);
        speed = spd;
        dir = direction;
        recalcAABB(); ensureDisplays(); ensureColliders(); updateVisualsAndColliders(true, 0.0);
        int[] d = dims();
        if(!method_37908().field_9236){
            var dt = method_5841();
            dt.method_12778(CX, (float)(base.field_1352+0.5));
            dt.method_12778(CY, (float)(base.field_1351));
            dt.method_12778(CZ, (float)(base.field_1350+0.5));
            dt.method_12778(VY, 0f);
            dt.method_12778(DW, d[0]); dt.method_12778(DL, d[1]); dt.method_12778(DH, d[2]);
        }
        moving = true;
    }

    @Override public void method_5773(){
        super.method_5773();
        if(method_37908().field_9236) return;

        class_243 step = moving ? new class_243(0, dir*speed, 0) : class_243.field_1353;
        if(moving){
            class_238 next = method_5829().method_997(step);
            if(method_37908().method_8587(this, next.method_1014(0.001))){
                base = base.method_1019(step);
                method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
                recalcAABB();
                updateVisualsAndColliders(false, step.field_1351);
                if(detectStopMarker((class_3218)method_37908())) moving = false;
            } else {
                reifyAndDiscard();
                return;
            }
        } else {
            updateVisualsAndColliders(false, 0.0);
        }
        if(moving){
            class_238 unionNext = method_5829().method_997(step);
            if(method_37908().method_8587(this, unionNext.method_1014(0.001))){
                base = base.method_1019(step);
                method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
                recalcAABB();
                updateVisualsAndColliders(false, step.field_1351);

                if(detectStopMarker((class_3218)method_37908())){ reifyAndDiscard(); return; }
            } else {
                reifyAndDiscard();
                return;
            }
        } else {
            updateVisualsAndColliders(false, 0.0);
        }

        int[] d = dims();
        var dt = method_5841();
        dt.method_12778(CX, (float)(base.field_1352+0.5));
        dt.method_12778(CY, (float)(base.field_1351));
        dt.method_12778(CZ, (float)(base.field_1350+0.5));
        dt.method_12778(VY, moving ? (float)(dir*speed) : 0f);
        dt.method_12778(DW, d[0]); dt.method_12778(DL, d[1]); dt.method_12778(DH, d[2]);
    }

    private int[] dims(){
        if(parts.isEmpty()) return new int[]{1,1,1};
        int minX=999999,minY=999999,minZ=999999,maxX=-999999,maxY=-999999,maxZ=-999999;
        for(Part p: parts){
            int x=p.off.method_10263(), y=p.off.method_10264(), z=p.off.method_10260();
            if(x<minX)minX=x; if(y<minY)minY=y; if(z<minZ)minZ=z;
            if(x>maxX)maxX=x; if(y>maxY)maxY=y; if(z>maxZ)maxZ=z;
        }
        int w=(maxX-minX)+1, l=(maxZ-minZ)+1, h=(maxY-minY)+1;
        if(w<1)w=1; if(l<1)l=1; if(h<1)h=1;
        return new int[]{w,l,h};
    }

    private boolean detectStopMarker(class_3218 sw){
        int range = 20;
        for(Part p: parts){
            int bx = (int)Math.floor(base.field_1352 + p.off.method_10263());
            int by = (int)Math.floor(base.field_1351 + p.off.method_10264());
            int bz = (int)Math.floor(base.field_1350 + p.off.method_10260());
            class_2338 here = new class_2338(bx,by,bz);

            // 4 directions sur la même Y
            // vers +X
            for(int dx=1; dx<=range; dx++){
                class_2338 mpos = here.method_10069(dx,0,0);
                if(sw.method_8320(mpos).method_27852(STOP_MARKER)){
                    boolean clear=true;
                    for(int i=1;i<dx;i++){ if(!sw.method_8320(here.method_10069(i,0,0)).method_26215()){ clear=false; break; } }
                    if(clear) return true;
                }
            }
            // vers -X
            for(int dx=1; dx<=range; dx++){
                class_2338 mpos = here.method_10069(-dx,0,0);
                if(sw.method_8320(mpos).method_27852(STOP_MARKER)){
                    boolean clear=true;
                    for(int i=1;i<dx;i++){ if(!sw.method_8320(here.method_10069(-i,0,0)).method_26215()){ clear=false; break; } }
                    if(clear) return true;
                }
            }
            // vers +Z
            for(int dz=1; dz<=range; dz++){
                class_2338 mpos = here.method_10069(0,0,dz);
                if(sw.method_8320(mpos).method_27852(STOP_MARKER)){
                    boolean clear=true;
                    for(int i=1;i<dz;i++){ if(!sw.method_8320(here.method_10069(0,0,i)).method_26215()){ clear=false; break; } }
                    if(clear) return true;
                }
            }
            // vers -Z
            for(int dz=1; dz<=range; dz++){
                class_2338 mpos = here.method_10069(0,0,-dz);
                if(sw.method_8320(mpos).method_27852(STOP_MARKER)){
                    boolean clear=true;
                    for(int i=1;i<dz;i++){ if(!sw.method_8320(here.method_10069(0,0,-i)).method_26215()){ clear=false; break; } }
                    if(clear) return true;
                }
            }
        }
        return false;
    }


    private void ensureDisplays(){
        if(method_37908().field_9236) return;
        for(Part p: parts){
            if(!displayIds.containsKey(p.off)){
                class_8113.class_8115 disp = new class_8113.class_8115(class_1299.field_42460, method_37908());
                disp.method_48883(p.state==null?class_2246.field_10085.method_9564():p.state);
                double x = base.field_1352 + p.off.method_10263();
                double y = base.field_1351 + p.off.method_10264();
                double z = base.field_1350 + p.off.method_10260();
                disp.method_5808(x, y, z, 0, 0);
                method_37908().method_8649(disp);
                displayIds.put(p.off, disp.method_5667());
            }
        }
    }

    private void ensureColliders(){
        if(method_37908().field_9236) return;
        for(Part p: parts){
            if(!colliderIds.containsKey(p.off)){
                net.kronoz.odyssey.entity.LiftPartColliderEntity col = ModEntities.LIFT_PART_COLLIDER.method_5883((class_3218)method_37908());
                if(col==null) continue;
                col.setParent(method_5667());
                double x = base.field_1352 + p.off.method_10263();
                double y = base.field_1351 + p.off.method_10264();
                double z = base.field_1350 + p.off.method_10260();
                col.method_5808(x+0.5, y, z+0.5, 0, 0);
                col.method_5857(new class_238(x, y, z, x+1, y+1, z+1));
                ((class_3218)method_37908()).method_8649(col);
                colliderIds.put(p.off, col.method_5667());
            }
        }
    }

    private void updateVisualsAndColliders(boolean snap, double stepY){
        if(method_37908().field_9236) return;
        for(Part p: parts){
            UUID id = displayIds.get(p.off);
            if(id!=null){
                class_1297 e = ((class_3218)method_37908()).method_14190(id);
                if(e instanceof class_8113.class_8115 disp){
                    double x = base.field_1352 + p.off.method_10263();
                    double y = base.field_1351 + p.off.method_10264();
                    double z = base.field_1350 + p.off.method_10260();
                    disp.method_23327(x, y, z);
                }
            }
            UUID cid = colliderIds.get(p.off);
            if(cid!=null){
                class_1297 e = ((class_3218)method_37908()).method_14190(cid);
                if(e instanceof net.kronoz.odyssey.entity.LiftPartColliderEntity col){
                    double x = base.field_1352 + p.off.method_10263();
                    double y = base.field_1351 + p.off.method_10264();
                    double z = base.field_1350 + p.off.method_10260();
                    col.method_23327(x+0.5, y, z+0.5);
                    col.method_5857(new class_238(x, y, z, x+1, y+1, z+1));
                    col.setStepY(stepY);
                }
            }
        }
        pruneMissing(parts, displayIds);
        pruneMissing(parts, colliderIds);
    }

    private static <T> void pruneMissing(List<Part> parts, Map<class_2338,UUID> map){
        Set<class_2338> keep = new HashSet<>();
        for(Part p: parts) keep.add(p.off);
        Iterator<Map.Entry<class_2338,UUID>> it = map.entrySet().iterator();
        while(it.hasNext()){
            Map.Entry<class_2338,UUID> en = it.next();
            if(!keep.contains(en.getKey())) it.remove();
        }
    }

    private void reifyAndDiscard(){
        if(!(method_37908() instanceof class_3218 sw)) { method_31472(); return; }
        for(Part p: parts){
            class_2338 at = new class_2338((int)Math.floor(base.field_1352 + p.off.method_10263()), (int)Math.floor(base.field_1351 + p.off.method_10264()), (int)Math.floor(base.field_1350 + p.off.method_10260()));
            sw.method_8652(at, p.state==null?class_2246.field_10085.method_9564():p.state, 3);
        }
        clearDisplays(); clearColliders(); method_31472();
    }

    private void clearDisplays(){
        if(method_37908().field_9236) return;
        for(UUID id: displayIds.values()){
            class_1297 e=((class_3218)method_37908()).method_14190(id);
            if(e!=null) e.method_31472();
        }
        displayIds.clear();
    }

    private void clearColliders(){
        if(method_37908().field_9236) return;
        for(UUID id: colliderIds.values()){
            class_1297 e=((class_3218)method_37908()).method_14190(id);
            if(e!=null) e.method_31472();
        }
        colliderIds.clear();
    }

    private void recalcAABB(){
        if(parts.isEmpty()){
            method_5857(new class_238(base.field_1352, base.field_1351, base.field_1350, base.field_1352+1, base.field_1351+1, base.field_1350+1));
            method_5808(base.field_1352+0.5, base.field_1351, base.field_1350+0.5, 0, 0);
            return;
        }
        double minX=Double.POSITIVE_INFINITY,minY=Double.POSITIVE_INFINITY,minZ=Double.POSITIVE_INFINITY;
        double maxX=Double.NEGATIVE_INFINITY,maxY=Double.NEGATIVE_INFINITY,maxZ=Double.NEGATIVE_INFINITY;
        for(Part p: parts){
            double x1=base.field_1352+p.off.method_10263(), y1=base.field_1351+p.off.method_10264(), z1=base.field_1350+p.off.method_10260();
            if(x1<minX)minX=x1; if(y1<minY)minY=y1; if(z1<minZ)minZ=z1;
            if(x1+1>maxX)maxX=x1+1; if(y1+1>maxY)maxY=y1+1; if(z1+1>maxZ)maxZ=z1+1;
        }
        method_5857(new class_238(minX,minY,minZ,maxX,maxY,maxZ));
        method_5808(base.field_1352+0.5, base.field_1351, base.field_1350+0.5, 0, 0);
    }

    @Override protected void method_5749(net.minecraft.class_2487 nbt){
        moving = nbt.method_10577("mv");
        dir = nbt.method_10550("dir");
        speed = nbt.method_10574("spd");
        origin = new class_2338(nbt.method_10550("ox"), nbt.method_10550("oy"), nbt.method_10550("oz"));
        base = new class_243(nbt.method_10574("bx"), nbt.method_10574("by"), nbt.method_10574("bz"));
        method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
        recalcAABB(); ensureDisplays(); ensureColliders(); updateVisualsAndColliders(true, 0.0);
    }

    @Override protected void method_5652(net.minecraft.class_2487 nbt){
        nbt.method_10556("mv", moving);
        nbt.method_10569("dir", dir);
        nbt.method_10549("spd", speed);
        nbt.method_10569("ox", origin.method_10263()); nbt.method_10569("oy", origin.method_10264()); nbt.method_10569("oz", origin.method_10260());
        nbt.method_10549("bx", base.field_1352); nbt.method_10549("by", base.field_1351); nbt.method_10549("bz", base.field_1350);
    }
}
