package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.block.SequencerRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;

public class SequencerBlockEntity extends class_2586 {

    public static class Step {
        public int second;
        public String key;
        public Step(int s, String k) { this.second = s; this.key = k; }
    }

    private final List<Step> steps = new ArrayList<>();
    private final BitSet fired = new BitSet();
    private boolean running = false;
    private long startTick = 0;
    private boolean loop = false;

    public SequencerBlockEntity(class_2338 pos, class_2680 state, class_2591<?> type) {
        super(type, pos, state);
    }

    public void setSteps(List<Step> list) {
        steps.clear();
        steps.addAll(list);
        steps.sort(Comparator.comparingInt(s -> s.second));
        fired.clear();
    }

    public void addStep(int second, String key) {
        steps.add(new Step(second, key));
        steps.sort(Comparator.comparingInt(s -> s.second));
    }

    public void setLoop(boolean loop) { this.loop = loop; }

    public void start(class_1937 world) {
        if (world.field_9236) return;
        running = true;
        fired.clear();
        startTick = world.method_8510();
        method_5431();
    }

    public void stop(class_1937 world) {
        if (world.field_9236) return;
        running = false;
        method_5431();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SequencerBlockEntity be) {
        if (world.field_9236 || !be.running || be.steps.isEmpty()) return;
        long elapsedTicks = world.method_8510() - be.startTick;
        if (elapsedTicks < 0) return;
        int elapsedSec = (int)(elapsedTicks / 20L);

        for (int i = 0; i < be.steps.size(); i++) {
            if (be.fired.get(i)) continue;
            Step s = be.steps.get(i);
            if (elapsedSec >= s.second) {
                SequencerRegistry.fire(s.key, (class_3218) world, pos);
                be.fired.set(i);
            }
        }

        if (be.fired.nextClearBit(0) >= be.steps.size()) {
            if (be.loop) {
                be.startTick = world.method_8510();
                be.fired.clear();
            } else {
                be.running = false;
            }
            be.method_5431();
        }
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        steps.clear();
        class_2499 list = nbt.method_10554("steps", class_2520.field_33260);
        for (class_2520 e : list) {
            class_2487 c = (class_2487) e;
            steps.add(new Step(c.method_10550("sec"), c.method_10558("key")));
        }
        running = nbt.method_10577("running");
        startTick = nbt.method_10537("start");
        loop = nbt.method_10577("loop");
        fired.clear();
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 list = new class_2499();
        for (Step s : steps) {
            class_2487 c = new class_2487();
            c.method_10569("sec", s.second);
            c.method_10582("key", s.key);
            list.add(c);
        }
        nbt.method_10566("steps", list);
        nbt.method_10556("running", running);
        nbt.method_10544("start", startTick);
        nbt.method_10556("loop", loop);
    }
}
