package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.init.ModBlockEntities;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;

public class Shelf1BlockEntity extends class_2586 implements GeoAnimatable {

    private final class_2371<class_1799> items = class_2371.method_10213(4, class_1799.field_8037);

    public Shelf1BlockEntity(class_2338 pos, class_2680 state) { super(ModBlockEntities.SHELF1, pos, state); }

    public int size() { return items.size(); }
    public int getFilledSlots() { int n = 0; for (class_1799 s : items) if (!s.method_7960()) n++; return n; }
    public class_1799 getStack(int slot) { return (slot < 0 || slot >= items.size()) ? class_1799.field_8037 : items.get(slot); }

    public void setStack(int slot, class_1799 stack) {
        if (slot < 0 || slot >= items.size()) return;
        items.set(slot, stack);
        syncDirty();
    }

    public void clearSlot(int slot) {
        if (slot < 0 || slot >= items.size()) return;
        items.set(slot, class_1799.field_8037);
        syncDirty();
    }

    public int firstEmptySlot() { for (int i=0;i<items.size();i++) if (items.get(i).method_7960()) return i; return -1; }
    public int lastFilledSlot() { for (int i=items.size()-1;i>=0;i--) if (!items.get(i).method_7960()) return i; return -1; }

    private void syncDirty() {
        method_5431();
        if (field_11863 == null || field_11863.field_9236) return;

        var sw = (net.minecraft.class_3218) field_11863;
        var pkt = net.minecraft.class_2622.method_38585(this);
        for (var player : net.fabricmc.fabric.api.networking.v1.PlayerLookup.tracking(sw, field_11867)) {
            player.field_13987.method_14364(pkt);
        }

        field_11863.method_8413(field_11867, method_11010(), method_11010(),
                net.minecraft.class_2248.field_31028 | net.minecraft.class_2248.field_31030);
        sw.method_14178().method_14128(field_11867);
    }



    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        class_1262.method_5426(nbt, items, lookup);
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        class_1262.method_5429(nbt, items, lookup);

        if (field_11863 != null && field_11863.field_9236) {
            var state = method_11010();
            ((net.minecraft.class_638) field_11863).method_16109(field_11867, state, state);
        }
    }



    @Nullable @Override
    public class_2622 method_38235() { return class_2622.method_38585(this); }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookup) {
        class_2487 n = new class_2487();
        class_1262.method_5426(n, items, lookup);
        return n;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {

    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return null;
    }

    @Override
    public double getTick(Object o) {
        return 0;
    }
}
