package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.block.custom.Shelf1Block;
import net.kronoz.odyssey.block.custom.Shelf1GeoModel;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;

import java.util.Optional;

public class Shelf1GeoBERenderer implements class_827<Shelf1BlockEntity> {
    private final Shelf1GeoModel model = new Shelf1GeoModel();

    // Fine tuning: slight downwards nudge so items sit flush; slight push off the wall if needed
    private static final float GLOBAL_ITEM_SCALE = 0.50f;
    private static final float Y_ADJUST = -0.01f;      // -1/100 block (lower a bit)
    private static final float SURFACE_PUSH = 0.001f;  // push forward a hair after rotations
    private static final boolean LAY_FLAT_NON_BLOCKS = true;

    public Shelf1GeoBERenderer(class_5614.class_5615 ctx) {}

    @Override
    public void render(Shelf1BlockEntity be, float tickDelta, class_4587 ms, class_4597 buffers, int light, int overlay) {
        if (be.method_10997() == null) return;

        class_2350 facing = be.method_11010().method_11654(Shelf1Block.FACING);
        BakedGeoModel baked = model.getBakedModel(model.getModelResource(be));

        for (int i = 0; i < be.size(); i++) {
            class_1799 stack = be.getStack(i);
            if (stack.method_7960()) continue;

            String boneName = "placeholder" + (i + 1);
            Optional<GeoBone> opt = baked.getBone(boneName);
            if (opt.isEmpty()) continue;
            GeoBone bone = opt.get();

            ms.method_22903();
            rotateToFacing(ms, facing);

            // --- PIVOT (Bedrock pixels) -> Java block space:
            float px = bone.getPivotX();
            float py = bone.getPivotY();
            float pz = bone.getPivotZ();

            // Map [-8..+8] px centered to [0..1] block; flip Z axis
            float bx = (px + 8.0f) / 16.0f;
            float by = (py) / 16.0f;
            float bz = (8.0f - pz) / 16.0f;

            ms.method_46416(bx, by + Y_ADJUST, bz);

            // Bone rotations are radians; apply Z -> Y -> X (matches Bedrock export)
            ms.method_22907(class_7833.field_40718.rotation(bone.getRotZ()));
            ms.method_22907(class_7833.field_40716.rotation(bone.getRotY()));
            ms.method_22907(class_7833.field_40714.rotation(bone.getRotX()));

            // Lay items flat if they aren't blocks
            if (LAY_FLAT_NON_BLOCKS && !(stack.method_7909() instanceof class_1747)) {
                ms.method_22907(class_7833.field_40714.rotationDegrees(90f));
            }

            // A tiny forward push so we don't Z-fight with the shelf surface
            ms.method_46416(0.0f, 0.0f, SURFACE_PUSH);

            ms.method_22905(GLOBAL_ITEM_SCALE, GLOBAL_ITEM_SCALE, GLOBAL_ITEM_SCALE);
            renderItem(stack, ms, buffers, light, i);
            ms.method_22909();
        }
    }

    private void rotateToFacing(class_4587 ms, class_2350 facing) {
        float yaw = switch (facing) {
            case field_11043 -> 0f;
            case field_11035 -> 180f;
            case field_11039  -> 90f;
            case field_11034  -> -90f;
            default    -> 0f;
        };
        ms.method_22904(0.5, 0, 0.5);
        ms.method_22907(new Quaternionf().rotationY((float) Math.toRadians(yaw)));
        ms.method_22904(-0.5, 0, -0.5);
    }

    private void renderItem(class_1799 stack, class_4587 ms, class_4597 buffers, int light, int slotIndex) {
        class_918 ir = class_310.method_1551().method_1480();
        var world = class_310.method_1551().field_1687;
        int seed = stack.method_7909().hashCode() ^ (slotIndex * 31);
        ir.method_23178(stack, class_811.field_4319, light, class_4608.field_21444, ms, buffers, world, seed);
    }
}
