package net.kronoz.odyssey.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_238;
import net.minecraft.class_243;

public final class ShelfSlots {
    public record SlotDef(
            String bone,
            class_238 pickBox,         // local-space [0..1] box for clicking
            class_243 translate,     // local pos (0..1)
            class_243 eulerDeg,      // rotation XYZ in degrees
            double scale         // uniform scale for item
    ) {}

    public static final List<SlotDef> LAYOUT = new ArrayList<>();

    static {
        // Example: 4 bones on a two-row shelf. Adjust to match your model.
        // pickBox is a small area in front of each bone (x,z in 0..1; y is 0..1)
        LAYOUT.add(new SlotDef(
                "bone_top_left",
                new class_238(0.18, 0.20, 0.30, 0.32, 0.60, 0.44),
                new class_243(0.25, 0.32, 0.37),
                new class_243(0, 0, 0),
                0.45
        ));
        LAYOUT.add(new SlotDef(
                "bone_top_right",
                new class_238(0.68, 0.20, 0.30, 0.82, 0.60, 0.44),
                new class_243(0.75, 0.32, 0.37),
                new class_243(0, 15, 0),
                0.45
        ));
        LAYOUT.add(new SlotDef(
                "bone_bottom_left",
                new class_238(0.18, 0.02, 0.30, 0.32, 0.34, 0.44),
                new class_243(0.25, 0.14, 0.37),
                new class_243(0, -10, 0),
                0.55
        ));
        LAYOUT.add(new SlotDef(
                "bone_bottom_right",
                new class_238(0.68, 0.02, 0.30, 0.82, 0.34, 0.44),
                new class_243(0.75, 0.14, 0.37),
                new class_243(0, 0, 0),
                0.55
        ));
    }

    public static int pickSlot(class_243 local01) {
        for (int i = 0; i < LAYOUT.size(); i++) {
            if (contains(LAYOUT.get(i).pickBox, local01)) return i;
        }
        return -1;
    }

    private static boolean contains(class_238 b, class_243 p) {
        return p.field_1352 >= b.field_1323 && p.field_1352 <= b.field_1320 &&
               p.field_1351 >= b.field_1322 && p.field_1351 <= b.field_1325 &&
               p.field_1350 >= b.field_1321 && p.field_1350 <= b.field_1324;
    }
}
