package net.kronoz.odyssey.entity;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import java.util.HashSet;

public class ShockwaveEntity extends class_1297 {
    private int duration = 40;
    private float maxRadius = 50f;
    private float band = 1.25f;
    private double yOffset = 0.05;
    private final HashSet<Integer> hit = new HashSet<>();


    private static final float BODY_LIGHT_BRIGHTNESS = 3.5f;
    private static final float BODY_LIGHT_RADIUS     = 30f;
    private static final float BODY_R = 1.00f, BODY_G = 1.00f, BODY_B = 0.00f;

    private PointLightData bodyLight;
    private LightRenderHandle<PointLightData> bodyLightHandle;

    public ShockwaveEntity(class_1299<? extends ShockwaveEntity> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
    }

    public void setup(float maxRadius, int duration, boolean overhead) {
        this.maxRadius = maxRadius;
        this.duration = Math.max(1, duration);
        this.band = Math.max(0.5f, maxRadius / 40f);
        this.yOffset = overhead ? 2.0 : 0.05;
    }

    public float getProgress(float tickDelta) {
        return Math.min(1f, (this.field_6012 + tickDelta) / Math.max(1f, this.duration));
    }

    public float getCurrentRadius(float tickDelta) {
        return maxRadius * getProgress(tickDelta);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {}



    @Override
    public void method_5773() {
        super.method_5773();

        if (this.field_6012++ >= this.duration) {
            freeLight();
            this.method_31472();
            return;
        }

        if (!this.method_37908().field_9236) {
            float r = getCurrentRadius(0f);
            float inner = Math.max(0f, r - band);
            class_238 box = new class_238(method_23317() - r - 1, method_23318() - 2, method_23321() - r - 1, method_23317() + r + 1, method_23318() + 2, method_23321() + r + 1);
            for (class_1309 le : this.method_37908().method_8390(class_1309.class, box, e -> e.method_5805()
                    && e.method_5864() != ModEntities.ARCANGEL
                    && e.method_5864() != ModEntities.APOSTASY
                    && e.method_5864() != ModEntities.SENTRY
                    && e.method_5864() != ModEntities.SENTINEL
                    && e.method_5864() != ModEntities.LASER_PROJECTILE)) {

                if (hit.contains(le.method_5628())) continue;
                class_243 d = le.method_19538().method_1023(method_23317(), le.method_23318(), method_23321());
                double dist2D = Math.hypot(d.field_1352, le.method_23321() - this.method_23321());
                if (dist2D >= inner && dist2D <= r + 0.75) {
                    float lvl = (le instanceof class_1657 pe) ? pe.field_7520 : nearestPlayerLevel(le);
                    float dmg = 4.0f + 0.18f * lvl;
                    le.method_5643(method_37908().method_48963().method_48830(), dmg);
                    class_243 n = new class_243(le.method_23317() - this.method_23317(), 0, le.method_23321() - this.method_23321());
                    double L = Math.max(0.001, Math.hypot(n.field_1352, n.field_1350));
                    n = n.method_1021(1.0 / L);
                    double h = 1.15 + Math.min(0.85, lvl * 0.02);
                    le.method_5762(n.field_1352 * h, 0.45 + Math.min(0.35, lvl * 0.01), n.field_1350 * h);
                    le.field_6007 = true;
                    hit.add(le.method_5628());
                }
            }
        }

        if (this.method_37908().field_9236) {
            boolean alive = this.method_5805() && !this.method_31481();

            if (!alive) {
                freeLight();
            } else {
                class_243 p = this.method_19538();

                if (bodyLightHandle != null && !bodyLightHandle.isValid()) {
                    freeLight();
                }

                if (bodyLightHandle == null) {
                    bodyLight = new PointLightData()
                            .setBrightness(BODY_LIGHT_BRIGHTNESS)
                            .setColor(BODY_R, BODY_G, BODY_B)
                            .setRadius(BODY_LIGHT_RADIUS)
                            .setPosition(p.field_1352, p.field_1351, p.field_1350);
                    bodyLightHandle = VeilRenderSystem.renderer().getLightRenderer().addLight(bodyLight);
                }

                float lifeProgress = (float)this.field_6012 / (float)this.duration;

                float radius = class_3532.method_16439(lifeProgress, BODY_LIGHT_RADIUS, 20f) * (getCurrentRadius(0f) / maxRadius);
                float r = 1.0f + lifeProgress * lifeProgress;
                float g = 0.5f;
                float b = 0.0f + lifeProgress;
                float brightness = class_3532.method_16439(lifeProgress, BODY_LIGHT_BRIGHTNESS, 0.1f);

                bodyLight
                        .setBrightness(brightness * brightness)
                        .setColor(r, g, b)
                        .setRadius(radius * radius)
                        .setPosition(p.field_1352, p.field_1351, p.field_1350);

                if (bodyLightHandle != null && bodyLightHandle.isValid()) {
                    bodyLightHandle.markDirty();
                }
            }
        }






    }


    @Override
    public void method_36209() {
        super.method_36209();
        freeLight();
    }




    private void freeLight() {
        if (bodyLightHandle != null && bodyLightHandle.isValid()) {
            bodyLightHandle.free();
        }
        bodyLightHandle = null;
        bodyLight = null;
    }


    private float nearestPlayerLevel(class_1309 around) {
        class_1657 p = this.method_37908().method_18460(around, 32.0);
        return p != null ? p.field_7520 : 0f;
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("dur")) duration = nbt.method_10550("dur");
        if (nbt.method_10545("rad")) maxRadius = nbt.method_10583("rad");
        if (nbt.method_10545("band")) band = nbt.method_10583("band");
        if (nbt.method_10545("yoff")) yOffset = nbt.method_10574("yoff");
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10569("dur", duration);
        nbt.method_10548("rad", maxRadius);
        nbt.method_10548("band", band);
        nbt.method_10549("yoff", yOffset);
    }

    @Override
    public boolean method_5640(double distance) { return true; }

    public double getYOffset() { return yOffset; }
}
