package net.kronoz.odyssey.entity;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix4f;

public class ShockwaveRenderer extends class_897<ShockwaveEntity> {
    private static final class_2960[] FRAMES = new class_2960[12];
    static {
        for (int i = 0; i < FRAMES.length; i++) {
            FRAMES[i] = class_2960.method_60655("odyssey","textures/effects/energy_shockwave_" + i + ".png");
        }
    }
    private static final int TICKS_PER_FRAME = 2;

    public ShockwaveRenderer(class_5617.class_5618 ctx) { super(ctx); }

    @Override
    public void render(ShockwaveEntity e, float yaw, float tickDelta, class_4587 matrices, class_4597 buffers, int light) {
        float t = e.getProgress(tickDelta);
        if (t >= 1f || e.method_31481()) return;

        float r = Math.max(0.25f, e.getCurrentRadius(tickDelta));
        float alpha = 1.0f - t;

        int frame = ((int)((e.field_6012 + tickDelta) / TICKS_PER_FRAME)) % FRAMES.length;
        class_2960 tex = FRAMES[frame];

        matrices.method_22903();
        matrices.method_22904(0, e.getYOffset(), 0);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90f));

        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f pose = entry.method_23761();

        class_4588 vc = buffers.getBuffer(class_1921.method_23026(tex));
        float u0=0f,v0=0f,u1=1f,v1=1f;

        vc.method_22918(pose, -r, -r, 0).method_22915(1f,1f,1f,alpha).method_22913(u0,v0).method_22922(class_4608.field_21444).method_60803(0x00F000F0).method_60831(entry,0,0,1);
        vc.method_22918(pose, -r,  r, 0).method_22915(1f,1f,1f,alpha).method_22913(u0,v1).method_22922(class_4608.field_21444).method_60803(0x00F000F0).method_60831(entry,0,0,1);
        vc.method_22918(pose,  r,  r, 0).method_22915(1f,1f,1f,alpha).method_22913(u1,v1).method_22922(class_4608.field_21444).method_60803(0x00F000F0).method_60831(entry,0,0,1);
        vc.method_22918(pose,  r, -r, 0).method_22915(1f,1f,1f,alpha).method_22913(u1,v0).method_22922(class_4608.field_21444).method_60803(0x00F000F0).method_60831(entry,0,0,1);

        matrices.method_22909();
        super.method_3936(e, yaw, tickDelta, matrices, buffers, light);
    }

    @Override
    public class_2960 getTexture(ShockwaveEntity entity) { return FRAMES[0]; }
}
