package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_8113;
import java.util.*;

public class SlidePlatformEntity extends class_1297 {
    public static class Part { public class_2338 off; public class_2680 state; public Part(class_2338 o, class_2680 s){ off=o; state=s; } }

    public static final class_2940<Float> CX = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> CY = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> CZ = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> VX = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Float> VZ = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13320);
    public static final class_2940<Integer> DW = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13327);
    public static final class_2940<Integer> DL = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13327);
    public static final class_2940<Integer> DH = class_2945.method_12791(SlidePlatformEntity.class, class_2943.field_13327);

    private final List<Part> parts = new ArrayList<>();
    private final Map<class_2338, UUID> displayIds = new HashMap<>();
    private final Map<class_2338, UUID> colliderIds = new HashMap<>();

    private class_243 base = class_243.field_1353;
    private double speed = 0.03;
    private int stepX=1, stepZ=0;

    // modes
    private boolean infinite = false;   // run until collision
    private class_2338 target = null;     // if non-null, stop when we reach/past this world cell
    private double movedAccum = 0.0;    // for HUD syncing (not strictly needed here)

    public SlidePlatformEntity(class_1299<? extends class_1297> type, class_1937 world){ super(type, world); this.field_5960=true; }
    @Override protected void method_5693(class_2945.class_9222 b){
        b.method_56912(CX,0f); b.method_56912(CY,0f); b.method_56912(CZ,0f); b.method_56912(VX,0f); b.method_56912(VZ,0f); b.method_56912(DW,1); b.method_56912(DL,1); b.method_56912(DH,1);
    }

    // ==== configure variants ====
    public void configureHorizontalInfinite(class_2338 originBlock, List<Part> p, double spd, int dx, int dz){
        initCommon(originBlock, p, spd, dx, dz);
        infinite = true;
        target = null;
    }
    public void configureHorizontalToTarget(class_2338 originBlock, List<Part> p, double spd, int dx, int dz, class_2338 targetCell){
        initCommon(originBlock, p, spd, dx, dz);
        infinite = false;
        target = targetCell;
    }
    private void initCommon(class_2338 originBlock, List<Part> p, double spd, int dx, int dz){
        base = new class_243(originBlock.method_10263(), originBlock.method_10264(), originBlock.method_10260());
        method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
        clearDisplays(); clearColliders();
        parts.clear(); parts.addAll(p);
        speed = Math.abs(spd);
        stepX = Integer.signum(dx); stepZ = Integer.signum(dz);
        movedAccum = 0.0;
        recalcAABB(); ensureDisplays(); ensureColliders(); updateAll(true, 0.0, 0.0);
        if(!method_37908().field_9236){
            int[] d = dims();
            var dt = method_5841();
            dt.method_12778(CX,(float)(base.field_1352+0.5)); dt.method_12778(CY,(float)base.field_1351); dt.method_12778(CZ,(float)(base.field_1350+0.5));
            dt.method_12778(VX,(float)(stepX*speed)); dt.method_12778(VZ,(float)(stepZ*speed));
            dt.method_12778(DW,d[0]); dt.method_12778(DL,d[1]); dt.method_12778(DH,d[2]);
        }
    }

    @Override public void method_5773(){
        super.method_5773();
        if(method_37908().field_9236) return;

        double mvx = stepX * speed;
        double mvz = stepZ * speed;

        // forward probe: if any part would enter a solid block next step => stop/reify
        if(willHitSolidAhead(mvx, mvz)){
            reifyAndDiscard();
            return;
        }

        class_243 step = new class_243(mvx, 0.0, mvz);
        class_238 nextBB = method_5829().method_997(step).method_1009(-0.01, 0.0, -0.01); // less “touchy” at edges
        boolean blocked = method_37908().method_20812(this, nextBB).iterator().hasNext();
        if(blocked){
            reifyAndDiscard();
            return;
        }

        base = base.method_1019(step);
        method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
        recalcAABB();
        updateAll(false, mvx, mvz);

        movedAccum += Math.abs(mvx) + Math.abs(mvz);

        // target mode: stop exactly when we reach/past the target cell on motion axis
        if(target != null){
            if(stepX != 0){
                if(stepX > 0 && base.field_1352 >= target.method_10263()) { reifyAndDiscard(); return; }
                if(stepX < 0 && base.field_1352 <= target.method_10263()) { reifyAndDiscard(); return; }
            } else if(stepZ != 0){
                if(stepZ > 0 && base.field_1350 >= target.method_10260()) { reifyAndDiscard(); return; }
                if(stepZ < 0 && base.field_1350 <= target.method_10260()) { reifyAndDiscard(); return; }
            }
        }

        // infinite mode: just keep going; reify happens only on collision
        int[] d = dims();
        var dt = method_5841();
        dt.method_12778(CX,(float)(base.field_1352+0.5)); dt.method_12778(CY,(float)base.field_1351); dt.method_12778(CZ,(float)(base.field_1350+0.5));
        dt.method_12778(VX,(float)(stepX*speed)); dt.method_12778(VZ,(float)(stepZ*speed));
        dt.method_12778(DW,d[0]); dt.method_12778(DL,d[1]); dt.method_12778(DH,d[2]);
    }

    private boolean willHitSolidAhead(double mvx, double mvz){
        final double ahead = 0.51;
        for(Part p : parts){
            double nx = base.field_1352 + p.off.method_10263() + (mvx > 0 ? ahead : (mvx < 0 ? -ahead : 0));
            double nz = base.field_1350 + p.off.method_10260() + (mvz > 0 ? ahead : (mvz < 0 ? -ahead : 0));
            int bx = (int)Math.floor(nx);
            int by = (int)Math.floor(base.field_1351 + p.off.method_10264());
            int bz = (int)Math.floor(nz);
            var st = method_37908().method_8320(new class_2338(bx, by, bz));
            if(!st.method_26215() && !st.method_26220(method_37908(), new class_2338(bx,by,bz)).method_1110()){
                return true;
            }
        }
        return false;
    }

    private int[] dims(){
        if(parts.isEmpty()) return new int[]{1,1,1};
        int minX=999999,minY=999999,minZ=999999,maxX=-999999,maxY=-999999,maxZ=-999999;
        for(Part p: parts){
            int x=p.off.method_10263(), y=p.off.method_10264(), z=p.off.method_10260();
            if(x<minX)minX=x; if(y<minY)minY=y; if(z<minZ)minZ=z;
            if(x>maxX)maxX=x; if(y>maxY)maxY=y; if(z>maxZ)maxZ=z;
        }
        int w=(maxX-minX)+1, l=(maxZ-minZ)+1, h=(maxY-minY)+1;
        if(w<1)w=1; if(l<1)l=1; if(h<1)h=1;
        return new int[]{w,l,h};
    }

    private void ensureDisplays(){
        if(method_37908().field_9236) return;
        for(Part p: parts){
            if(!displayIds.containsKey(p.off)){
                class_8113.class_8115 disp=new class_8113.class_8115(class_1299.field_42460, method_37908());
                disp.method_48883(p.state==null?class_2246.field_10085.method_9564():p.state);
                double x=base.field_1352+p.off.method_10263(), y=base.field_1351+p.off.method_10264(), z=base.field_1350+p.off.method_10260();
                disp.method_5808(x,y,z,0,0);
                method_37908().method_8649(disp);
                displayIds.put(p.off, disp.method_5667());
            }
        }
    }
    private void ensureColliders(){
        if(method_37908().field_9236) return;
        for(Part p: parts){
            if(!colliderIds.containsKey(p.off)){
                SlidePartColliderEntity col = ModEntities.SLIDE_PART_COLLIDER.method_5883((class_3218)method_37908());
                if(col==null) continue;
                double x=base.field_1352+p.off.method_10263(), y=base.field_1351+p.off.method_10264(), z=base.field_1350+p.off.method_10260();
                col.method_5808(x+0.5,y+0.5,z+0.5,0,0);
                double eps=0.025; // 0.95 wide
                col.method_5857(new class_238(x+eps,y,z+eps,x+1-eps,y+1,z+1-eps));
                ((class_3218)method_37908()).method_8649(col);
                colliderIds.put(p.off, col.method_5667());
            }
        }
    }
    private void updateAll(boolean snap, double vx, double vz){
        if(method_37908().field_9236) return;
        for(Part p: parts){
            UUID id=displayIds.get(p.off);
            if(id!=null){
                class_1297 e=((class_3218)method_37908()).method_14190(id);
                if(e instanceof class_8113.class_8115 d){
                    double x=base.field_1352+p.off.method_10263(), y=base.field_1351+p.off.method_10264(), z=base.field_1350+p.off.method_10260();
                    d.method_23327(x,y,z);
                }
            }
            UUID cid=colliderIds.get(p.off);
            if(cid!=null){
                class_1297 e=((class_3218)method_37908()).method_14190(cid);
                if(e instanceof SlidePartColliderEntity c){
                    double x=base.field_1352+p.off.method_10263(), y=base.field_1351+p.off.method_10264(), z=base.field_1350+p.off.method_10260();
                    c.method_23327(x+0.5,y+0.5,z+0.5);
                    double eps=0.025; // 0.95 wide
                    c.method_5857(new class_238(x+eps,y,z+eps,x+1-eps,y+1,z+1-eps));
                    c.setStep(vx, vz);
                }
            }
        }
        prune(parts, displayIds); prune(parts, colliderIds);
    }
    private static void prune(List<Part> parts, Map<class_2338,UUID> map){
        HashSet<class_2338> keep=new HashSet<>(); for(Part p: parts) keep.add(p.off);
        map.entrySet().removeIf(e->!keep.contains(e.getKey()));
    }

    private void clearDisplays(){
        if(method_37908().field_9236) return;
        for(UUID id: displayIds.values()){
            class_1297 e=((class_3218)method_37908()).method_14190(id);
            if(e!=null) e.method_31472();
        }
        displayIds.clear();
    }
    private void clearColliders(){
        if(method_37908().field_9236) return;
        for(UUID id: colliderIds.values()){
            class_1297 e=((class_3218)method_37908()).method_14190(id);
            if(e!=null) e.method_31472();
        }
        colliderIds.clear();
    }

    private void recalcAABB(){
        if(parts.isEmpty()){
            method_5857(new class_238(base.field_1352,base.field_1351,base.field_1350,base.field_1352+1,base.field_1351+1,base.field_1350+1));
            method_5808(base.field_1352+0.5, base.field_1351, base.field_1350+0.5, 0,0);
            return;
        }
        double minX=Double.POSITIVE_INFINITY,minY=Double.POSITIVE_INFINITY,minZ=Double.POSITIVE_INFINITY;
        double maxX=Double.NEGATIVE_INFINITY,maxY=Double.NEGATIVE_INFINITY,maxZ=Double.NEGATIVE_INFINITY;
        for(Part p: parts){
            double x1=base.field_1352+p.off.method_10263(), y1=base.field_1351+p.off.method_10264(), z1=base.field_1350+p.off.method_10260();
            if(x1<minX)minX=x1; if(y1<minY)minY=y1; if(z1<minZ)minZ=z1;
            if(x1+1>maxX)maxX=x1+1; if(y1+1>maxY)maxY=y1+1; if(z1+1>maxZ)maxZ=z1+1;
        }
        method_5857(new class_238(minX,minY,minZ,maxX,maxY,maxZ));
        method_5808(base.field_1352+0.5, base.field_1351, base.field_1350+0.5, 0,0);
    }

    private void reifyAndDiscard(){
        if(!(method_37908() instanceof class_3218 sw)){ method_31472(); return; }
        for(Part p: parts){
            class_2338 at = new class_2338((int)Math.floor(base.field_1352+p.off.method_10263()), (int)Math.floor(base.field_1351+p.off.method_10264()), (int)Math.floor(base.field_1350+p.off.method_10260()));
            sw.method_8652(at, p.state==null?class_2246.field_10085.method_9564():p.state, 3);
        }
        clearDisplays(); clearColliders();
        method_31472();
    }

    @Override protected void method_5749(net.minecraft.class_2487 nbt){
        base=new class_243(nbt.method_10574("bx"), nbt.method_10574("by"), nbt.method_10574("bz"));
        speed=nbt.method_10574("spd"); stepX=nbt.method_10550("sx"); stepZ=nbt.method_10550("sz");
        method_23327(base.field_1352+0.5, base.field_1351, base.field_1350+0.5);
        ensureDisplays(); ensureColliders(); updateAll(true,0,0);
    }
    @Override protected void method_5652(net.minecraft.class_2487 nbt){
        nbt.method_10549("bx",base.field_1352); nbt.method_10549("by",base.field_1351); nbt.method_10549("bz",base.field_1350);
        nbt.method_10549("spd",speed); nbt.method_10569("sx",stepX); nbt.method_10569("sz",stepZ);
    }
}
