package net.kronoz.odyssey.entity;

import net.kronoz.odyssey.init.ModBlockEntities;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.*;

public class SlidingDoorBlockEntity extends class_2586 {
    public static class Part { public class_2338 off; public class_2680 state; public Part(class_2338 o, class_2680 s){ off=o; state=s; } }

    private final List<Part> parts = new ArrayList<>();
    private UUID platformId = null;

    private class_2338 home = class_2338.field_10980;
    private class_2338 lastOrigin = class_2338.field_10980;
    private class_2350 axis = class_2350.field_11034;
    private int sideSign = +1;
    private double speed = 0.03;
    private boolean isOpen = false;

    public SlidingDoorBlockEntity(class_2338 pos, class_2680 state){ super(ModBlockEntities.SLIDING_DOOR_BE,pos,state); }
    public static void serverTick(class_1937 w, class_2338 p, class_2680 s, SlidingDoorBlockEntity be){}

    private class_1937 w(){ return Objects.requireNonNull(method_10997()); }

    public void toggle(class_3218 sw, class_2350 facing){
        if(home.equals(class_2338.field_10980)) home = this.field_11867;
        scan(sw);
        if(parts.isEmpty()) return;

        axis = facing.method_10170();

        removeBlocks(sw);

        SlidePlatformEntity e = ensure(sw);
        if(e == null) return;

        int dx = axis.method_10166()==class_2350.class_2351.field_11048 ? axis.method_10148() * (isOpen ? -sideSign : sideSign) : 0;
        int dz = axis.method_10166()==class_2350.class_2351.field_11051 ? axis.method_10165() * (isOpen ? -sideSign : sideSign) : 0;

        class_2338 runOrigin = isOpen ? lastOrigin : this.field_11867;

        if(!isOpen){
            e.configureHorizontalInfinite(runOrigin, copy(), speed, dx, dz);
        }else{
            e.configureHorizontalToTarget(runOrigin, copy(), speed, dx, dz, home);
        }

        isOpen = !isOpen;
        lastOrigin = runOrigin;

        method_5431();
    }

    private List<SlidePlatformEntity.Part> copy(){
        List<SlidePlatformEntity.Part> out=new ArrayList<>();
        for(Part p: parts) out.add(new SlidePlatformEntity.Part(p.off,p.state));
        return out;
    }

    private void scan(class_3218 sw){
        parts.clear();
        HashSet<class_2338> vis=new HashSet<>();
        ArrayDeque<class_2338> q=new ArrayDeque<>();
        q.add(this.field_11867); vis.add(this.field_11867);
        class_2248 self=w().method_8320(this.field_11867).method_26204();
        while(!q.isEmpty()){
            class_2338 c=q.pollFirst();
            class_2680 s=sw.method_8320(c);
            if(s.method_26204()!=self) continue;
            parts.add(new Part(c.method_10059(this.field_11867), s));
            for(class_2338 n: new class_2338[]{c.method_10095(),c.method_10072(),c.method_10078(),c.method_10067(),c.method_10084(),c.method_10074()}){
                if(!vis.contains(n) && sw.method_8320(n).method_26204()==self){ vis.add(n); q.add(n); }
            }
        }
    }

    private void removeBlocks(class_3218 sw){
        class_2248 self=w().method_8320(this.field_11867).method_26204();
        for(Part p: parts){
            class_2338 at=this.field_11867.method_10081(p.off);
            if(sw.method_8320(at).method_26204()==self) sw.method_8652(at, net.minecraft.class_2246.field_10124.method_9564(), class_2248.field_31036);
        }
    }

    private SlidePlatformEntity ensure(class_3218 sw){
        if(platformId==null || !(sw.method_14190(platformId) instanceof SlidePlatformEntity)){
            SlidePlatformEntity e = ModEntities.SLIDE_PLATFORM.method_5883(sw);
            if(e==null) return null;
            e.method_5808(this.field_11867.method_10263()+0.5, this.field_11867.method_10264(), this.field_11867.method_10260()+0.5, 0, 0);
            sw.method_8649(e);
            platformId=e.method_5667();
            return e;
        }
        return (SlidePlatformEntity) sw.method_14190(platformId);
    }

    @Override protected void method_11007(class_2487 nbt, class_7225.class_7874 l){
        class_2499 list=new class_2499();
        for(Part p: parts){
            class_2487 t=new class_2487();
            t.method_10569("x",p.off.method_10263()); t.method_10569("y",p.off.method_10264()); t.method_10569("z",p.off.method_10260());
            t.method_10566("state", class_2512.method_10686(p.state));
            list.add(t);
        }
        nbt.method_10566("parts",list);
        if(platformId!=null) nbt.method_25927("pid",platformId);

        nbt.method_10569("homeX",home.method_10263()); nbt.method_10569("homeY",home.method_10264()); nbt.method_10569("homeZ",home.method_10260());
        nbt.method_10569("lastX",lastOrigin.method_10263()); nbt.method_10569("lastY",lastOrigin.method_10264()); nbt.method_10569("lastZ",lastOrigin.method_10260());
        nbt.method_10569("axisH", axis.method_10161());
        nbt.method_10569("sideSign", sideSign);
        nbt.method_10549("speed", speed);
        nbt.method_10556("isOpen", isOpen);
    }

    @Override protected void method_11014(class_2487 nbt, class_7225.class_7874 l){
        parts.clear();
        if(nbt.method_10573("parts", class_2520.field_33259)){
            class_2499 list=nbt.method_10554("parts", class_2520.field_33260);
            for(int i=0;i<list.size();i++){
                class_2487 t=list.method_10602(i);
                class_2338 off=new class_2338(t.method_10550("x"),t.method_10550("y"),t.method_10550("z"));
                class_2680 st=class_2512.method_10681(l.method_46762(class_7924.field_41254), t.method_10562("state"));
                parts.add(new Part(off,st));
            }
        }
        platformId = nbt.method_25928("pid") ? nbt.method_25926("pid") : null;

        home = new class_2338(nbt.method_10550("homeX"), nbt.method_10550("homeY"), nbt.method_10550("homeZ"));
        lastOrigin = new class_2338(nbt.method_10550("lastX"), nbt.method_10550("lastY"), nbt.method_10550("lastZ"));
        axis = class_2350.method_10139(nbt.method_10550("axisH"));
        sideSign = nbt.method_10545("sideSign") ? nbt.method_10550("sideSign") : +1;
        speed = nbt.method_10545("speed") ? nbt.method_10574("speed") : 0.03;
        isOpen = nbt.method_10577("isOpen");
    }
}
